/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.devops.repair;

import com.xforceplus.ultraman.oqsengine.devops.repair.CommitIdRepairExecutor;
import com.xforceplus.ultraman.oqsengine.status.CommitIdStatusService;
import com.xforceplus.ultraman.oqsengine.storage.master.MasterStorage;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Optional;
import javax.annotation.Resource;

public class CommitIdRepairExecutorImpl
implements CommitIdRepairExecutor {
    @Resource
    private MasterStorage masterStorage;
    @Resource
    private CommitIdStatusService commitIdStatusService;
    private static final long INIT_COMMIT_ID = 1L;

    @Override
    public void clean(Long ... ids) {
        if (null == ids || ids.length == 0) {
            this.commitIdStatusService.obsoleteAll();
        } else {
            long[] arrayIds = new long[ids.length];
            for (int i = 0; i < ids.length; ++i) {
                arrayIds[i] = ids[i];
            }
            this.commitIdStatusService.obsolete(arrayIds);
        }
    }

    @Override
    public long[] rangeOfCommitId() {
        long[] range = new long[]{this.commitIdStatusService.getMin().orElse(0L), this.commitIdStatusService.getMax().orElse(0L)};
        return range;
    }

    @Override
    public long[] allCommitIds() {
        return this.commitIdStatusService.getAll();
    }

    @Override
    public void cleanLessThan(long id) {
        long[] result = Arrays.stream(this.commitIdStatusService.getAll()).filter(s -> s > id).toArray();
        this.commitIdStatusService.obsolete(result);
    }

    @Override
    @Deprecated
    public void repair(Optional<Long> commitId) throws SQLException {
    }
}

