/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.event.payload.transaction;

import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;

public class CommitPayload
implements Serializable {
    private long txId;
    private long commitId;
    private String msg;
    private boolean readonly;
    private long maxOpNumber;

    public CommitPayload(long txId, long commitId, String msg, boolean readonly, long maxOpNumber) {
        this.txId = txId;
        this.commitId = commitId;
        this.msg = msg;
        this.readonly = readonly;
        this.maxOpNumber = maxOpNumber;
    }

    public long getTxId() {
        return this.txId;
    }

    public long getCommitId() {
        return this.commitId;
    }

    public Optional<String> getMsg() {
        return Optional.ofNullable(this.msg);
    }

    public long getMaxOpNumber() {
        return this.maxOpNumber;
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommitPayload that = (CommitPayload)o;
        return this.txId == that.txId && this.commitId == that.commitId && this.readonly == that.readonly && this.maxOpNumber == that.maxOpNumber && Objects.equals(this.msg, that.msg);
    }

    public int hashCode() {
        return Objects.hash(this.txId, this.commitId, this.msg, this.readonly, this.maxOpNumber);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("CommitPayload{");
        sb.append("txId=").append(this.txId);
        sb.append(", commitId=").append(this.commitId);
        sb.append(", msg='").append(this.msg).append('\'');
        sb.append(", readonly=").append(this.readonly);
        sb.append(", maxOpNumber=").append(this.maxOpNumber);
        sb.append('}');
        return sb.toString();
    }
}

