/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.event.storage;

import com.xforceplus.ultraman.oqsengine.event.Event;
import com.xforceplus.ultraman.oqsengine.event.storage.EventStorage;
import java.util.Comparator;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;

public class MemoryEventStorage
implements EventStorage {
    private Queue<Event> eventQueue = new PriorityBlockingQueue(16, new EventComparator().reversed());
    private AtomicInteger size = new AtomicInteger(0);

    @Override
    public boolean push(Event event) {
        if (this.eventQueue.offer(event)) {
            this.size.incrementAndGet();
            return true;
        }
        return false;
    }

    @Override
    public Optional<Event> pop() {
        Event event = this.eventQueue.poll();
        if (event != null) {
            this.size.decrementAndGet();
            return Optional.of(event);
        }
        return Optional.empty();
    }

    @Override
    public void clear() {
        this.size.set(0);
        this.eventQueue.clear();
    }

    @Override
    public int size() {
        return this.size.get();
    }

    static class EventComparator
    implements Comparator<Event> {
        EventComparator() {
        }

        @Override
        public int compare(Event o1, Event o2) {
            if (o1.priority().getValue() < o2.priority().getValue()) {
                return -1;
            }
            if (o1.priority().getValue() > o2.priority().getValue()) {
                return 1;
            }
            return 0;
        }
    }
}

