/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.event.payload.entity;

import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntity;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.IValue;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ReplacePayload
implements Serializable {
    private long txId;
    private Map<IEntity, IValue[]> changes;

    public ReplacePayload(long txId) {
        this.txId = txId;
    }

    public long getTxId() {
        return this.txId;
    }

    public void addChange(IEntity entity, IValue[] newValues) {
        if (this.changes == null) {
            this.changes = new HashMap<IEntity, IValue[]>();
        }
        this.changes.put(entity, newValues);
    }

    public Map<IEntity, IValue[]> getChanges() {
        if (this.changes == null) {
            return Collections.emptyMap();
        }
        return this.changes;
    }

    public Optional<Map.Entry<IEntity, IValue[]>> getChanage(IEntity entity) {
        IValue[] newValues = this.getChanges().get(entity);
        if (newValues == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(new AbstractMap.SimpleEntry<IEntity, IValue[]>(entity, newValues));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ReplacePayload)) {
            return false;
        }
        ReplacePayload that = (ReplacePayload)o;
        return this.getTxId() == that.getTxId() && Objects.equals(this.getChanges(), that.getChanges());
    }

    public int hashCode() {
        return Objects.hash(this.getTxId(), this.getChanges());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ReplacePayload{");
        sb.append("changes=").append(this.changes);
        sb.append(", txId=").append(this.txId);
        sb.append('}');
        return sb.toString();
    }
}

