/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.idgenerator.executor;

import com.xforceplus.ultraman.oqsengine.common.executor.Executor;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSegmentExecutor<R, T>
implements Executor<R, T> {
    final Logger logger = LoggerFactory.getLogger(AbstractSegmentExecutor.class);
    private String tableName;
    private DataSource dataSource;
    private long timeoutMs;

    public AbstractSegmentExecutor(String tableName, DataSource resource) {
        this(tableName, resource, 0L);
    }

    public AbstractSegmentExecutor(String tableName, DataSource resource, long timeoutMs) {
        this.tableName = tableName;
        this.dataSource = resource;
        this.timeoutMs = timeoutMs;
    }

    public String getTableName() {
        return this.tableName;
    }

    public long getTimeoutMs() {
        return this.timeoutMs;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    protected void checkTimeout(Statement statement) throws SQLException {
        if (this.getTimeoutMs() > 0L) {
            statement.setQueryTimeout((int)(this.getTimeoutMs() / 1000L));
        }
    }
}

