/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.idgenerator.storage;

import com.xforceplus.ultraman.oqsengine.common.lifecycle.Lifecycle;
import com.xforceplus.ultraman.oqsengine.idgenerator.common.entity.SegmentInfo;
import com.xforceplus.ultraman.oqsengine.idgenerator.executor.SegmentBuildExecutor;
import com.xforceplus.ultraman.oqsengine.idgenerator.executor.SegmentDeleteExecutor;
import com.xforceplus.ultraman.oqsengine.idgenerator.executor.SegmentQueryExecutor;
import com.xforceplus.ultraman.oqsengine.idgenerator.executor.SegmentResetExecutor;
import com.xforceplus.ultraman.oqsengine.idgenerator.executor.SegmentUpdateExecutor;
import com.xforceplus.ultraman.oqsengine.idgenerator.storage.SegmentStorage;
import java.sql.SQLException;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.sql.DataSource;

public class SqlSegmentStorage
implements SegmentStorage,
Lifecycle {
    @Resource(name="segmentDataSource")
    private DataSource dataSource;
    private String table;
    private long queryTimeout;

    @PostConstruct
    public void init() {
        if (this.queryTimeout <= 0L) {
            this.setQueryTimeout(3000L);
        }
    }

    public void setTable(String table) {
        this.table = table;
    }

    public void setQueryTimeout(long queryTimeout) {
        this.queryTimeout = queryTimeout;
    }

    @Override
    public int build(SegmentInfo segmentInfo) throws SQLException {
        return SegmentBuildExecutor.build(this.table, this.dataSource, this.queryTimeout).execute(segmentInfo);
    }

    @Override
    public int udpate(SegmentInfo segmentInfo) throws SQLException {
        return SegmentUpdateExecutor.build(this.table, this.dataSource, this.queryTimeout).execute(segmentInfo);
    }

    public int reset(SegmentInfo segmentInfo) throws SQLException {
        return SegmentResetExecutor.build(this.table, this.dataSource, this.queryTimeout).execute(segmentInfo);
    }

    @Override
    public int delete(SegmentInfo segmentInfo) throws SQLException {
        return SegmentDeleteExecutor.build(this.table, this.dataSource, this.queryTimeout).execute(segmentInfo);
    }

    @Override
    public Optional<SegmentInfo> query(String bizType) throws SQLException {
        try {
            return (Optional)SegmentQueryExecutor.build(this.table, this.dataSource, this.queryTimeout).execute(bizType);
        }
        catch (Exception e) {
            throw (SQLException)e;
        }
    }
}

