/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.idgenerator.executor;

import com.xforceplus.ultraman.oqsengine.idgenerator.common.entity.SegmentInfo;
import com.xforceplus.ultraman.oqsengine.idgenerator.executor.AbstractSegmentExecutor;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collections;
import javax.sql.DataSource;

public class SegmentBuildExecutor
extends AbstractSegmentExecutor<SegmentInfo, Integer> {
    public SegmentBuildExecutor(String tableName, DataSource resource, long timeout) {
        super(tableName, resource, timeout);
    }

    public static SegmentBuildExecutor build(String tableName, DataSource dataSource, long timeout) {
        return new SegmentBuildExecutor(tableName, dataSource, timeout);
    }

    public Integer execute(SegmentInfo res) throws SQLException {
        String sql = this.buildSQL();
        try (Connection connection = this.getDataSource().getConnection();){
            Integer n;
            block13: {
                PreparedStatement st = connection.prepareStatement(sql);
                try {
                    int pos = 1;
                    st.setString(pos++, res.getBizType());
                    st.setLong(pos++, res.getBeginId());
                    st.setLong(pos++, res.getMaxId());
                    st.setInt(pos++, res.getStep());
                    st.setString(pos++, res.getPattern());
                    st.setString(pos++, res.getPatternKey());
                    st.setInt(pos++, res.getResetable());
                    st.setInt(pos++, res.getMode());
                    st.setLong(pos++, res.getVersion());
                    st.setTimestamp(pos++, res.getCreateTime());
                    st.setTimestamp(pos, res.getUpdateTime());
                    this.checkTimeout(st);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug(st.toString());
                    }
                    n = st.executeUpdate();
                    if (st == null) break block13;
                }
                catch (Throwable throwable) {
                    if (st != null) {
                        try {
                            st.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                st.close();
            }
            return n;
        }
    }

    private String buildSQL() {
        StringBuilder buff = new StringBuilder();
        buff.append("INSERT INTO ").append(this.getTableName()).append(' ').append("(").append(String.join((CharSequence)",", "biz_type", "begin_id", "max_id", "step", "pattern", "pattern_key", "resetable", "mode", "version", "create_time", "update_time")).append(") VALUES (").append(String.join((CharSequence)",", Collections.nCopies(11, "?"))).append(")");
        return buff.toString();
    }
}

