/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.idgenerator.generator.impl;

import com.xforceplus.ultraman.oqsengine.idgenerator.common.entity.IDResult;
import com.xforceplus.ultraman.oqsengine.idgenerator.common.entity.ResultCode;
import com.xforceplus.ultraman.oqsengine.idgenerator.common.entity.SegmentId;
import com.xforceplus.ultraman.oqsengine.idgenerator.exception.IDGeneratorException;
import com.xforceplus.ultraman.oqsengine.idgenerator.generator.IDGenerator;
import com.xforceplus.ultraman.oqsengine.idgenerator.service.SegmentService;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalCacheGenerator
implements IDGenerator {
    protected String bizType;
    protected SegmentService segmentService;
    protected volatile SegmentId current;
    protected volatile SegmentId next;
    private volatile boolean isLoadingNext;
    private Object lock = new Object();
    private ExecutorService executorService;
    private Logger logger = LoggerFactory.getLogger(LocalCacheGenerator.class);

    public LocalCacheGenerator(String bizType, SegmentService segmentService, ExecutorService executorService) {
        this.bizType = bizType;
        this.segmentService = segmentService;
        this.executorService = executorService;
        this.loadCurrent();
    }

    public synchronized void loadCurrent() {
        if (this.current != null && !this.current.useful() && this.logger.isDebugEnabled()) {
            this.logger.debug("\u4e0d\u53ef\u7528 current :{}", (Object)this.current);
        }
        if (this.current == null || !this.current.useful()) {
            if (this.next == null) {
                SegmentId segmentId;
                this.current = segmentId = this.querySegmentId();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("next \u4e3a\u7a7a {}");
                }
            } else {
                this.current = this.next;
                this.next = null;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("\u53ef\u7528\u4e86{}", (Object)this.current);
                }
            }
        }
    }

    public synchronized void resetBizType(IDResult result) {
        String message = null;
        if (this.current != null) {
            this.current = null;
        }
        if (this.next != null) {
            this.next = null;
        }
        String patternKey = result.getPatternKey();
        try {
            this.segmentService.resetSegment(this.bizType, patternKey);
        }
        catch (Throwable throwable) {
            message = throwable.getMessage();
        }
        if (message != null) {
            throw new IDGeneratorException("Error reset the segment: " + message);
        }
    }

    private SegmentId querySegmentId() {
        String message = null;
        try {
            SegmentId segmentId = this.segmentService.getNextSegmentId(this.bizType);
            if (segmentId != null) {
                return segmentId;
            }
        }
        catch (Exception e) {
            message = e.getMessage();
        }
        throw new IDGeneratorException("error query segment: " + message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadNext() {
        if (this.next == null && !this.isLoadingNext) {
            Object object = this.lock;
            synchronized (object) {
                if (this.next == null && !this.isLoadingNext) {
                    this.isLoadingNext = true;
                    this.executorService.submit(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                LocalCacheGenerator.this.next = LocalCacheGenerator.this.querySegmentId();
                            }
                            finally {
                                LocalCacheGenerator.this.isLoadingNext = false;
                            }
                        }
                    });
                }
            }
        }
    }

    @Override
    public String nextId() {
        IDResult result;
        while (true) {
            if (this.current == null) {
                this.loadCurrent();
                continue;
            }
            result = this.current.nextId();
            if (result.getCode() == ResultCode.OVER) {
                this.loadCurrent();
                continue;
            }
            if (result.getCode() != ResultCode.RESET) break;
            this.resetBizType(result);
        }
        if (result.getCode() == ResultCode.LOADING) {
            this.loadNext();
        }
        return result.getId();
    }

    @Override
    public List<String> nextIds(Integer batchSize) {
        ArrayList<String> ids = new ArrayList<String>();
        for (int i = 0; i < batchSize; ++i) {
            String id = this.nextId();
            ids.add(id);
        }
        return ids;
    }
}

