/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.idgenerator.generator.impl;

import com.alibaba.google.common.cache.CacheBuilder;
import com.alibaba.google.common.cache.CacheLoader;
import com.alibaba.google.common.cache.LoadingCache;
import com.xforceplus.ultraman.oqsengine.idgenerator.common.constant.ResetModel;
import com.xforceplus.ultraman.oqsengine.idgenerator.common.entity.SegmentInfo;
import com.xforceplus.ultraman.oqsengine.idgenerator.common.entity.TimeDelay;
import com.xforceplus.ultraman.oqsengine.idgenerator.exception.IDGeneratorException;
import com.xforceplus.ultraman.oqsengine.idgenerator.generator.IDGenerator;
import com.xforceplus.ultraman.oqsengine.idgenerator.parser.PatternParserManager;
import com.xforceplus.ultraman.oqsengine.idgenerator.parser.impl.DatePatternParser;
import com.xforceplus.ultraman.oqsengine.idgenerator.service.SegmentService;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RAtomicLong;
import org.redisson.api.RedissonClient;

public class RedisCacheImpl
implements IDGenerator {
    private static final Long MAX_SIZE = 20000L;
    private static final Long MAX_CACHE_TIME_IN_SECONDS = 3600L;
    private PatternParserManager patternParserManager;
    protected SegmentService segmentService;
    private RedissonClient redissonClient;
    private String bizType;
    private RAtomicLong counter;
    protected LoadingCache<String, RAtomicLong> cache;

    public RedisCacheImpl(SegmentService segmentService, final RedissonClient redissonClient, String bizType, PatternParserManager patternParserManager) {
        this.segmentService = segmentService;
        this.redissonClient = redissonClient;
        this.bizType = bizType;
        this.patternParserManager = patternParserManager;
        SegmentInfo segmentInfo = segmentService.getSegmentInfo(this.bizType);
        if (segmentInfo.getResetable().equals(ResetModel.UNRESETABLE.value())) {
            this.counter = redissonClient.getAtomicLong(bizType);
        } else {
            this.cache = CacheBuilder.newBuilder().maximumSize(MAX_SIZE.longValue()).expireAfterWrite(MAX_CACHE_TIME_IN_SECONDS.longValue(), TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<String, RAtomicLong>(){

                public RAtomicLong load(String key) throws SQLException {
                    RAtomicLong atomicLong = redissonClient.getAtomicLong(key);
                    return atomicLong;
                }
            });
        }
    }

    @Override
    public String nextId() {
        SegmentInfo segmentInfo = this.segmentService.getSegmentInfo(this.bizType);
        Long id = 0L;
        if (segmentInfo.getResetable().equals(ResetModel.UNRESETABLE.value())) {
            id = this.counter.incrementAndGet();
        } else {
            String key = String.format("%s-%s", this.bizType, this.patternParserManager.parse(segmentInfo.getPattern(), 0L));
            RAtomicLong counter = null;
            try {
                TimeDelay delay;
                counter = (RAtomicLong)this.cache.get((Object)key);
                id = counter.incrementAndGet();
                if (counter.remainTimeToLive() == -1L && (delay = DatePatternParser.getMaxExpireDate(segmentInfo.getPattern())) != null) {
                    counter.expire((long)delay.getDelay(), delay.getTimeUnit());
                }
            }
            catch (Exception e) {
                String errorMsg = String.format("Get IdModel : %s failed!", this.bizType);
                throw new IDGeneratorException(errorMsg);
            }
        }
        return this.patternParserManager.parse(segmentInfo.getPattern(), id);
    }

    @Override
    public List<String> nextIds(Integer batchSize) {
        return null;
    }
}

