/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.idgenerator.parser;

import com.xforceplus.ultraman.oqsengine.idgenerator.common.entity.PatternValue;
import com.xforceplus.ultraman.oqsengine.idgenerator.exception.IDGeneratorException;
import com.xforceplus.ultraman.oqsengine.idgenerator.parser.PatternParserManager;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class PatternParserUtil
implements ApplicationContextAware {
    private static final String REGEX_PATTEN = "\\{(0+)\\}";
    private static ApplicationContext applicationContext;
    private static final Pattern LAST_NUMBER_PATTERN;

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        applicationContext = context;
    }

    public static PatternParserManager getInstance() {
        return (PatternParserManager)applicationContext.getBean(PatternParserManager.class);
    }

    public static String parse(String patten, Long id) {
        return PatternParserUtil.getInstance().parse(patten, id);
    }

    public static boolean needReset(String pattern, PatternValue current, PatternValue next) {
        return !PatternParserUtil.getPatternKey(pattern, current).equals(PatternParserUtil.getPatternKey(pattern, next));
    }

    public static String getPatternKey(String pattern, PatternValue patternValue) {
        int numberPatternLength = 0;
        int start = 0;
        String left = "";
        Pattern regexPattern = Pattern.compile(REGEX_PATTEN);
        Matcher matcher = regexPattern.matcher(pattern);
        if (!matcher.find()) {
            throw new IDGeneratorException("Error pattern! pattern must contain {0000} part!");
        }
        numberPatternLength = matcher.group(1).length();
        start = matcher.start();
        left = pattern.substring(0, matcher.start());
        if (numberPatternLength < String.valueOf(patternValue.getId()).length()) {
            numberPatternLength = String.valueOf(patternValue.getId()).length();
        }
        if (left.contains("{yyyy}")) {
            start -= 2;
        }
        if (left.contains("{MM}")) {
            start -= 2;
        }
        if (left.contains("{dd}")) {
            start -= 2;
        }
        if (left.contains("{HH}")) {
            start -= 2;
        }
        String value = patternValue.getValue();
        return String.format("%s%s", value.substring(0, start), value.substring(start + numberPatternLength));
    }

    static {
        LAST_NUMBER_PATTERN = Pattern.compile("\\d+$");
    }
}

