/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.idgenerator.parser.impl;

import com.xforceplus.ultraman.oqsengine.idgenerator.parser.PatternParser;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NumberPatternParser
implements PatternParser {
    private static final String REGEX_PATTEN = "\\{(0+)\\}";

    @Override
    public String getName() {
        return "number_patten_parser";
    }

    @Override
    public String parse(String patten, Long id) {
        String ret = id.toString();
        Pattern pattern = Pattern.compile(REGEX_PATTEN);
        Matcher matcher = pattern.matcher(patten);
        if (matcher.find()) {
            String idStr = matcher.group(1);
            String formatStr = "%0" + idStr.length() + "d";
            ret = patten.replace(patten.substring(matcher.start(), matcher.end()), String.format(formatStr, id));
        }
        return ret;
    }

    @Override
    public boolean needHandle(String str) {
        Pattern pattern = Pattern.compile(REGEX_PATTEN);
        Matcher matcher = pattern.matcher(str);
        return matcher.find();
    }
}

