/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.idgenerator.parser.impl;

import com.xforceplus.ultraman.oqsengine.idgenerator.common.entity.TimeDelay;
import com.xforceplus.ultraman.oqsengine.idgenerator.parser.PatternParser;
import java.time.LocalDateTime;
import java.util.concurrent.TimeUnit;

public class DatePatternParser
implements PatternParser {
    @Override
    public String getName() {
        return "data_patten_parser";
    }

    public LocalDateTime getLocalDate() {
        return LocalDateTime.now();
    }

    public static TimeDelay getMaxExpireDate(String pattern) {
        if (pattern.contains("{HH}")) {
            return new TimeDelay(1, TimeUnit.HOURS);
        }
        if (pattern.contains("{dd}") && !pattern.contains("{HH}")) {
            return new TimeDelay(1, TimeUnit.DAYS);
        }
        if (pattern.contains("{MM}") && !pattern.contains("{dd}") && !pattern.contains("{HH}")) {
            return new TimeDelay(31, TimeUnit.DAYS);
        }
        if (pattern.contains("{yyyy}") && !pattern.contains("{MM}") && !pattern.contains("{dd}") && !pattern.contains("{HH}")) {
            return new TimeDelay(366, TimeUnit.DAYS);
        }
        return null;
    }

    @Override
    public String parse(String patten, Long id) {
        LocalDateTime date = this.getLocalDate();
        String year = String.valueOf(date.getYear());
        String month = String.format("%02d", date.getMonthValue());
        String day = String.format("%02d", date.getDayOfMonth());
        String hour = String.format("%02d", date.getHour());
        return patten.replace("{dd}", day).replace("{MM}", month).replace("{yyyy}", year).replace("{HH}", hour);
    }

    @Override
    public boolean needHandle(String patten) {
        return patten.contains("{yyyy}") || patten.contains("{MM}") || patten.contains("{dd}") || patten.contains("{HH}");
    }
}

