/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.idgenerator.common.entity;

import com.xforceplus.ultraman.oqsengine.idgenerator.common.constant.ResetModel;
import com.xforceplus.ultraman.oqsengine.idgenerator.common.entity.IDResult;
import com.xforceplus.ultraman.oqsengine.idgenerator.common.entity.PatternValue;
import com.xforceplus.ultraman.oqsengine.idgenerator.common.entity.ResultCode;
import com.xforceplus.ultraman.oqsengine.idgenerator.parser.PatternParserUtil;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentId
implements Serializable,
Cloneable {
    private static final Logger LOGGER = LoggerFactory.getLogger(SegmentId.class);
    private static final long serialVersionUID = -5222792505264340312L;
    private long maxId;
    private long loadingId;
    private AtomicReference<PatternValue> currentId = new AtomicReference();
    private String pattern;
    private int resetable;

    public SegmentId clone() {
        SegmentId cloneObj = null;
        try {
            cloneObj = (SegmentId)super.clone();
            cloneObj.currentId = new AtomicReference();
            cloneObj.currentId.set((PatternValue)this.currentId.get().clone());
            return cloneObj;
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            throw new RuntimeException("Clone failed!");
        }
    }

    String convert(Long id) {
        return PatternParserUtil.getInstance().parse(this.pattern, id);
    }

    public IDResult nextId() {
        PatternValue nextValue;
        PatternValue currentValue;
        while (!this.currentId.compareAndSet(currentValue = this.currentId.get(), nextValue = new PatternValue(currentValue.getId() + 1L, PatternParserUtil.getInstance().parse(this.pattern, currentValue.getId() + 1L)))) {
        }
        if (nextValue.getId() > this.maxId) {
            return new IDResult(ResultCode.OVER, this.convert(nextValue.getId()));
        }
        if (nextValue.getId() >= this.loadingId) {
            return new IDResult(ResultCode.LOADING, this.convert(nextValue.getId()));
        }
        if (PatternParserUtil.needReset(this.pattern, currentValue, nextValue) && ResetModel.fromValue(this.resetable).equals((Object)ResetModel.RESETABLE)) {
            LOGGER.info("Need reset currentValue  : {}, nextValue : {}", (Object)currentValue, (Object)nextValue);
            return new IDResult(ResultCode.RESET, this.convert(nextValue.getId()), PatternParserUtil.getPatternKey(this.pattern, nextValue));
        }
        return new IDResult(ResultCode.NORMAL, this.convert(nextValue.getId()));
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public boolean useful() {
        return this.currentId.get().getId() <= this.maxId;
    }

    public long getMaxId() {
        return this.maxId;
    }

    public void setMaxId(long maxId) {
        this.maxId = maxId;
    }

    public long getLoadingId() {
        return this.loadingId;
    }

    public void setLoadingId(long loadingId) {
        this.loadingId = loadingId;
    }

    public PatternValue getCurrentId() {
        return this.currentId.get();
    }

    public void setCurrentId(PatternValue pattenValue) {
        this.currentId.set(pattenValue);
    }

    public int getResetable() {
        return this.resetable;
    }

    public void setResetable(int resetable) {
        this.resetable = resetable;
    }

    public String toString() {
        return "[maxId=" + this.maxId + ",loadingId=" + this.loadingId + ",currentId=" + this.currentId.toString() + ",patten=" + this.pattern + "]";
    }
}

