/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.idgenerator.executor;

import com.xforceplus.ultraman.oqsengine.idgenerator.common.entity.SegmentInfo;
import com.xforceplus.ultraman.oqsengine.idgenerator.executor.AbstractSegmentExecutor;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import javax.sql.DataSource;

public class SegmentUpdateExecutor
extends AbstractSegmentExecutor<SegmentInfo, Integer> {
    public SegmentUpdateExecutor(String tableName, DataSource dataSource, long timeoutMs) {
        super(tableName, dataSource, timeoutMs);
    }

    public static SegmentUpdateExecutor build(String tableName, DataSource dataSource, long timeout) {
        return new SegmentUpdateExecutor(tableName, dataSource, timeout);
    }

    public Integer execute(SegmentInfo segmentInfo) throws SQLException {
        String sql = this.buildSQL();
        try (Connection connection = this.getDataSource().getConnection();){
            Integer n;
            block13: {
                PreparedStatement st = connection.prepareStatement(sql);
                try {
                    st.setLong(1, segmentInfo.getId());
                    st.setLong(2, segmentInfo.getMaxId());
                    st.setLong(3, segmentInfo.getVersion());
                    st.setString(4, segmentInfo.getBizType());
                    this.checkTimeout(st);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug(st.toString());
                    }
                    n = st.executeUpdate();
                    if (st == null) break block13;
                }
                catch (Throwable throwable) {
                    if (st != null) {
                        try {
                            st.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                st.close();
            }
            return n;
        }
    }

    private String buildSQL() {
        StringBuilder buff = new StringBuilder();
        buff.append("UPDATE ").append(this.getTableName()).append(" SET ").append("version").append(" = ").append(String.format("%s + %s", "version", "1")).append(" , ").append("max_id").append(" = ").append(String.format("%s + %s", "max_id", "step")).append(" WHERE ").append("id").append(" = ").append("?").append(" AND ").append("max_id").append(" = ").append("?").append(" AND ").append("version").append(" = ").append("?").append(" AND ").append("biz_type").append(" = ").append("?");
        return buff.toString();
    }
}

