/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.idgenerator.generator;

import com.alibaba.google.common.collect.Maps;
import com.xforceplus.ultraman.oqsengine.idgenerator.common.NamedThreadFactory;
import com.xforceplus.ultraman.oqsengine.idgenerator.common.constant.IDModel;
import com.xforceplus.ultraman.oqsengine.idgenerator.exception.IDGeneratorException;
import com.xforceplus.ultraman.oqsengine.idgenerator.generator.IDGenerator;
import com.xforceplus.ultraman.oqsengine.idgenerator.generator.IDGeneratorFactory;
import com.xforceplus.ultraman.oqsengine.idgenerator.generator.impl.LocalCacheGenerator;
import com.xforceplus.ultraman.oqsengine.idgenerator.generator.impl.RedisCacheImpl;
import com.xforceplus.ultraman.oqsengine.idgenerator.parser.PatternParserManager;
import com.xforceplus.ultraman.oqsengine.idgenerator.parser.PatternParserUtil;
import com.xforceplus.ultraman.oqsengine.idgenerator.service.SegmentService;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Resource;
import org.redisson.api.RedissonClient;

public class IDGeneratorFactoryImpl
implements IDGeneratorFactory {
    @Resource
    private SegmentService segmentService;
    private ExecutorService executorService;
    private Map<String, IDGenerator> generators = Maps.newConcurrentMap();
    private Map<String, IDGenerator> distributeGenerators = Maps.newConcurrentMap();
    @Resource
    private RedissonClient redissonClient;
    @Resource
    private PatternParserManager patternParserManager;

    public IDGeneratorFactoryImpl() {
        this.executorService = Executors.newSingleThreadExecutor(new NamedThreadFactory("oqs-id-generator"));
    }

    @Override
    public IDGenerator getIdGenerator(String bizType) {
        IDModel model = this.segmentService.getIDModel(bizType);
        if (model.equals((Object)IDModel.TREND_INC)) {
            return this.generators.computeIfAbsent(bizType, s -> this.createIdGenerator((String)s));
        }
        if (model.equals((Object)IDModel.LINEAR_INC)) {
            return this.distributeGenerators.computeIfAbsent(bizType, s -> this.createDistributeGenerator((String)s));
        }
        throw new IDGeneratorException("\u4e0d\u652f\u6301\u7684\u8ba1\u6570\u7c7b\u578b!");
    }

    protected IDGenerator createIdGenerator(String bizType) {
        return new LocalCacheGenerator(bizType, this.segmentService, this.executorService);
    }

    protected IDGenerator createDistributeGenerator(String bizType) {
        return new RedisCacheImpl(this.segmentService, this.redissonClient, bizType, PatternParserUtil.getInstance());
    }
}

