/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.idgenerator.generator.impl;

import com.xforceplus.ultraman.oqsengine.idgenerator.common.entity.IDResult;
import com.xforceplus.ultraman.oqsengine.idgenerator.common.entity.ResultCode;
import com.xforceplus.ultraman.oqsengine.idgenerator.common.entity.SegmentId;
import com.xforceplus.ultraman.oqsengine.idgenerator.exception.IDGeneratorException;
import com.xforceplus.ultraman.oqsengine.idgenerator.generator.IDGenerator;
import com.xforceplus.ultraman.oqsengine.idgenerator.service.SegmentService;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.redisson.api.RAtomicLong;
import org.redisson.api.RBucket;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;

public class RedisCacheGenerator
implements IDGenerator {
    protected SegmentService segmentService;
    private RedissonClient redissonClient;
    private RBucket<SegmentId> current;
    private RBucket<SegmentId> next;
    private RAtomicLong isLoadingNext;
    private String bizType;
    private ExecutorService executorService;

    public RedisCacheGenerator(String bizType, SegmentService segmentService, ExecutorService executorService, RedissonClient redissonClient) {
        this.segmentService = segmentService;
        this.redissonClient = redissonClient;
        this.current = redissonClient.getBucket(String.format("%s:%s", bizType, "current"));
        this.next = redissonClient.getBucket(String.format("%s:%s", bizType, "next"));
        this.isLoadingNext = redissonClient.getAtomicLong(String.format("%s:%s", bizType, "loadingNext"));
        this.executorService = executorService;
        this.bizType = bizType;
        this.loadCurrent(bizType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void loadCurrent(String bizType) {
        RLock lock = this.redissonClient.getLock(bizType);
        lock.lock();
        try {
            if (this.current.get() == null || !((SegmentId)this.current.get()).useful()) {
                if (this.next == null || this.next.get() == null) {
                    SegmentId segmentId = this.querySegmentId(bizType);
                    this.current.set((Object)segmentId);
                } else {
                    this.current.set((Object)((SegmentId)this.next.get()));
                    this.next.set(null);
                }
            }
        }
        finally {
            lock.unlock();
        }
    }

    private SegmentId querySegmentId(String bizType) {
        String message = null;
        try {
            SegmentId segmentId = this.segmentService.getNextSegmentId(bizType);
            if (segmentId != null) {
                return segmentId;
            }
        }
        catch (Exception e) {
            message = e.getMessage();
            throw new IDGeneratorException(String.format("error query segment: bizType: %s error message :%s ", bizType, message));
        }
        throw new IDGeneratorException(String.format("error query segment: bizType: %s error message :%s ", bizType, message));
    }

    public void loadNext() {
        if (this.next.get() == null && this.isLoadingNext.get() == 0L) {
            RLock lock = this.redissonClient.getLock(this.bizType);
            lock.lock();
            try {
                if (this.next.get() == null && this.isLoadingNext.get() == 0L) {
                    this.isLoadingNext.incrementAndGet();
                    this.executorService.submit(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                RedisCacheGenerator.this.next.set((Object)RedisCacheGenerator.this.querySegmentId(RedisCacheGenerator.this.bizType));
                            }
                            finally {
                                RedisCacheGenerator.this.isLoadingNext.decrementAndGet();
                            }
                        }
                    });
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void resetBizType(IDResult result) {
        RLock lock = this.redissonClient.getLock(this.bizType);
        lock.lock();
        try {
            String message = null;
            if (this.current != null) {
                this.current.set(null);
            }
            if (this.next != null) {
                this.next.set(null);
            }
            String patternKey = result.getPatternKey();
            try {
                this.segmentService.resetSegment(this.bizType, patternKey);
            }
            catch (Throwable throwable) {
                message = throwable.getMessage();
            }
            if (message != null) {
                throw new IDGeneratorException("Error reset the segment: " + message);
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String nextId() {
        IDResult result;
        while (true) {
            if (this.current.get() == null) {
                this.loadCurrent(this.bizType);
                continue;
            }
            result = null;
            RLock lock = this.redissonClient.getLock(this.bizType);
            lock.lock();
            try {
                SegmentId currentValue = (SegmentId)this.current.get();
                SegmentId nextValue = currentValue.clone();
                result = nextValue.nextId();
                this.current.set((Object)nextValue);
            }
            finally {
                lock.unlock();
            }
            if (result.getCode() == ResultCode.OVER) {
                this.loadCurrent(this.bizType);
                continue;
            }
            if (result.getCode() != ResultCode.RESET) break;
            this.resetBizType(result);
        }
        if (result.getCode() == ResultCode.LOADING && this.isLoadingNext.get() == 0L) {
            this.loadNext();
        }
        return result.getId();
    }

    @Override
    public List<String> nextIds(Integer batchSize) {
        ArrayList<String> ids = new ArrayList<String>();
        for (int i = 0; i < batchSize; ++i) {
            String id = this.nextId();
            ids.add(id);
        }
        return ids;
    }
}

