/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.idgenerator.parser;

import com.alibaba.google.common.collect.Maps;
import com.xforceplus.ultraman.oqsengine.idgenerator.parser.PatternParser;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class PatternParserManager
implements InitializingBean,
ApplicationContextAware {
    private Map<String, PatternParser> registedParser = Maps.newConcurrentMap();
    private ApplicationContext applicationContext;

    public void registVariableParser(PatternParser parser) {
        this.registedParser.put(parser.getName(), parser);
    }

    public void unRegist(String name) {
        this.registedParser.remove(name);
    }

    public String parse(String pattern, Long id) {
        String newValue = pattern;
        for (PatternParser parser : this.registedParser.values()) {
            if (!parser.needHandle(newValue)) continue;
            newValue = parser.parse(newValue, id);
        }
        return newValue;
    }

    public void afterPropertiesSet() {
        this.applicationContext.getBeansOfType(PatternParser.class).entrySet().stream().forEach(entry -> this.registVariableParser((PatternParser)entry.getValue()));
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

