/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.idgenerator.service.impl;

import com.alibaba.google.common.cache.CacheBuilder;
import com.alibaba.google.common.cache.CacheLoader;
import com.alibaba.google.common.cache.LoadingCache;
import com.xforceplus.ultraman.oqsengine.idgenerator.common.constant.IDModel;
import com.xforceplus.ultraman.oqsengine.idgenerator.common.entity.PatternValue;
import com.xforceplus.ultraman.oqsengine.idgenerator.common.entity.SegmentId;
import com.xforceplus.ultraman.oqsengine.idgenerator.common.entity.SegmentInfo;
import com.xforceplus.ultraman.oqsengine.idgenerator.exception.IDGeneratorException;
import com.xforceplus.ultraman.oqsengine.idgenerator.parser.PatternParserUtil;
import com.xforceplus.ultraman.oqsengine.idgenerator.service.SegmentService;
import com.xforceplus.ultraman.oqsengine.idgenerator.storage.SqlSegmentStorage;
import java.sql.SQLException;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentServiceImpl
implements SegmentService {
    @Resource
    SqlSegmentStorage sqlSegmentStorage;
    private static final Logger LOGGER = LoggerFactory.getLogger(SegmentServiceImpl.class);
    private static final Long MAX_CACHE_TIME_IN_SECONDS = 600L;
    private static final Long MAX_SIZE = 10000L;
    protected LoadingCache<String, SegmentInfo> cache = CacheBuilder.newBuilder().maximumSize(MAX_SIZE.longValue()).expireAfterWrite(MAX_CACHE_TIME_IN_SECONDS.longValue(), TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<String, SegmentInfo>(){

        public SegmentInfo load(String key) throws SQLException {
            return SegmentServiceImpl.this.innerGetSegmentInfo(key);
        }
    });

    @Override
    public SegmentId getNextSegmentId(String bizType) throws SQLException {
        for (int i = 0; i < 6; ++i) {
            SegmentInfo segmentInfo = this.innerGetSegmentInfo(bizType);
            Long newMaxId = segmentInfo.getMaxId() + (long)segmentInfo.getStep().intValue();
            int row = this.sqlSegmentStorage.udpate(segmentInfo);
            if (row == 1) {
                segmentInfo.setMaxId(newMaxId);
                SegmentId segmentId = this.convert(segmentInfo);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("getNextSegmentId success segmentInfo:{} current:{}", (Object)segmentInfo, (Object)segmentId);
                }
                return segmentId;
            }
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug("getNextSegmentId conflict segmentInfo:{}", (Object)segmentInfo);
        }
        throw new IDGeneratorException("get next segment conflict");
    }

    @Override
    public boolean resetSegment(String bizType, String patternKey) throws SQLException {
        SegmentInfo segmentInfo = this.innerGetSegmentInfo(bizType);
        segmentInfo.setPatternKey(patternKey);
        int row = this.sqlSegmentStorage.reset(segmentInfo);
        return row > 0;
    }

    private SegmentInfo innerGetSegmentInfo(String bizType) {
        Optional<SegmentInfo> targetSegmentInfo = null;
        try {
            targetSegmentInfo = this.sqlSegmentStorage.query(bizType);
        }
        catch (SQLException e) {
            throw new IDGeneratorException("query bizType failed!", e);
        }
        if (!targetSegmentInfo.isPresent()) {
            throw new IDGeneratorException("Can not find bizType:" + bizType);
        }
        return targetSegmentInfo.get();
    }

    @Override
    public SegmentInfo getSegmentInfo(String bizType) {
        try {
            return (SegmentInfo)this.cache.get((Object)bizType);
        }
        catch (ExecutionException e) {
            String errorMsg = String.format("Get segment : %s failed!", bizType);
            LOGGER.error(errorMsg, (Throwable)e);
            throw new IDGeneratorException(errorMsg);
        }
    }

    @Override
    public IDModel getIDModel(String bizType) {
        IDModel model = null;
        try {
            SegmentInfo segmentInfo = (SegmentInfo)this.cache.get((Object)bizType);
            model = this.getIDModel(segmentInfo);
        }
        catch (CacheLoader.InvalidCacheLoadException e) {
            LOGGER.warn(String.format("Get invalidCache : %s", bizType));
        }
        catch (Exception e) {
            String errorMsg = String.format("Get IdModel : %s failed!", bizType);
            LOGGER.error(errorMsg, (Throwable)e);
            throw new IDGeneratorException(errorMsg);
        }
        return model;
    }

    private IDModel getIDModel(SegmentInfo segmentInfo) {
        return IDModel.fromValue(segmentInfo.getMode());
    }

    public SegmentId convert(SegmentInfo idInfo) {
        SegmentId segmentId = new SegmentId();
        long id = idInfo.getMaxId() - (long)idInfo.getStep().intValue();
        String value = PatternParserUtil.getInstance().parse(idInfo.getPattern(), id);
        PatternValue pattenValue = new PatternValue(id, value);
        segmentId.setCurrentId(pattenValue);
        segmentId.setMaxId(idInfo.getMaxId());
        segmentId.setPattern(idInfo.getPattern());
        segmentId.setResetable(idInfo.getResetable());
        segmentId.setLoadingId(segmentId.getCurrentId().getId() + (long)(idInfo.getStep() * 30 / 100));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Loading Id set to {}", (Object)segmentId.getLoadingId());
        }
        return segmentId;
    }
}

