/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.lock;

import com.xforceplus.ultraman.oqsengine.common.lifecycle.Lifecycle;
import com.xforceplus.ultraman.oqsengine.common.watch.RedisLuaScriptWatchDog;
import com.xforceplus.ultraman.oqsengine.lock.AbstractResourceLocker;
import com.xforceplus.ultraman.oqsengine.lock.utils.Locker;
import com.xforceplus.ultraman.oqsengine.lock.utils.StateKeys;
import io.lettuce.core.RedisClient;
import io.lettuce.core.ScriptOutputType;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.api.sync.RedisCommands;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;

public class RedisResourceLocker
extends AbstractResourceLocker
implements Lifecycle {
    private static final String LOCK_SCRIPT = "local newLocker = ARGV[1];local ttl = ARGV[2];local curor = 0;for i=1, #KEYS, 1 do  local hasLocked = redis.call('EXISTS', KEYS[i]);  if hasLocked == 1 then    local locker = redis.call('HGET', KEYS[i], 'locker');    if (locker == newLocker) then      redis.call('HINCRBY', KEYS[i], 'acc', 1);      redis.call('PEXPIRE', KEYS[i], ttl);    else     return curor;    end;  else    redis.call('HMSET', KEYS[i], 'locker', newLocker, 'acc', 1);    redis.call('PEXPIRE', KEYS[i], ttl);  end;  curor = curor + 1;end;return curor;";
    private static final String UNLOCK_SCRIPT = "local freeLocker = ARGV[1];local failKeyIndexPoint = 1;local failKeyIndex = {};for i=1, #KEYS, 1 do  local hasLocked = redis.call('EXISTS', KEYS[i]);  if hasLocked == 1 then    local locker = redis.call('HGET', KEYS[i], 'locker');    if locker ~= freeLocker then      failKeyIndex[failKeyIndexPoint] = i - 1;      failKeyIndexPoint = failKeyIndexPoint + 1;    else      local acc = redis.call('HINCRBY', KEYS[i], 'acc', -1);      if acc == 0 then        redis.call('DEL', KEYS[i]);      end;    end;  end;end;return failKeyIndex;";
    @Resource(name="redisClient")
    private RedisClient redisClient;
    @Resource
    private RedisLuaScriptWatchDog redisLuaScriptWatchDog;
    @Resource(name="taskThreadPool")
    private ExecutorService worker;
    private StatefulRedisConnection<String, String> connection;
    private RedisCommands<String, String> syncCommands;
    private String lockScriptSha;
    private String unLockScriptSha;
    private long ttlMs = 30000L;
    private String ttlMsString;

    public RedisResourceLocker() {
    }

    public RedisResourceLocker(RedisClient redisClient) {
        this.redisClient = redisClient;
    }

    public void setTtlMs(long ttlMs) {
        this.ttlMs = ttlMs;
    }

    public long getTtlMs() {
        return this.ttlMs;
    }

    @PostConstruct
    public void init() throws Exception {
        if (this.redisClient == null) {
            throw new IllegalStateException("Invalid redisClient.");
        }
        this.connection = this.redisClient.connect();
        this.syncCommands = this.connection.sync();
        if (this.redisLuaScriptWatchDog != null) {
            this.lockScriptSha = this.redisLuaScriptWatchDog.watch(LOCK_SCRIPT);
            this.unLockScriptSha = this.redisLuaScriptWatchDog.watch(UNLOCK_SCRIPT);
        } else {
            this.lockScriptSha = this.syncCommands.scriptLoad(LOCK_SCRIPT);
            this.unLockScriptSha = this.syncCommands.scriptLoad(UNLOCK_SCRIPT);
        }
        this.ttlMsString = Long.toString(this.ttlMs);
    }

    @PreDestroy
    public void destroy() throws Exception {
        this.connection.close();
    }

    @Override
    protected void doLocks(Locker locker, StateKeys stateKeys) {
        Object[] keys = stateKeys.getNoCompleteKeys();
        long size = (Long)this.syncCommands.evalsha(this.lockScriptSha, ScriptOutputType.INTEGER, keys, (Object[])new String[]{locker.getName(), this.ttlMsString});
        int i = 0;
        while ((long)i < size) {
            stateKeys.move();
            ++i;
        }
    }

    @Override
    protected int[] doUnLocks(Locker locker, StateKeys stateKeys) {
        Object[] keys = stateKeys.getNoCompleteKeys();
        int[] failKeyIndex = ((List)this.syncCommands.evalsha(this.unLockScriptSha, ScriptOutputType.MULTI, keys, (Object[])new String[]{locker.getName()})).stream().mapToInt(i -> i.intValue()).sorted().toArray();
        return failKeyIndex;
    }

    @Override
    protected boolean doIsLocking(String key) {
        return this.syncCommands.exists((Object[])new String[]{key}) > 0L;
    }
}

