/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.lock;

import com.xforceplus.ultraman.oqsengine.lock.AbstractResourceLocker;
import com.xforceplus.ultraman.oqsengine.lock.utils.Locker;
import com.xforceplus.ultraman.oqsengine.lock.utils.StateKeys;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class LocalResourceLocker
extends AbstractResourceLocker {
    private final ConcurrentMap<String, LockInfo> lockPool = new ConcurrentHashMap<String, LockInfo>();

    @Override
    protected void doLocks(Locker locker, StateKeys stateKeys) {
        String[] keys = stateKeys.getNoCompleteKeys();
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            LockInfo newLockInfo = new LockInfo(locker);
            LockInfo oldLockInfo = this.lockPool.putIfAbsent(key, newLockInfo);
            if (oldLockInfo != null) {
                if (!oldLockInfo.getLocker().equals(locker.getName())) {
                    return;
                }
                oldLockInfo.incr();
                stateKeys.move();
                continue;
            }
            stateKeys.move();
        }
    }

    @Override
    protected int[] doUnLocks(Locker locker, StateKeys stateKeys) {
        String[] keys = stateKeys.getNoCompleteKeys();
        ArrayList<Integer> failKeyIndex = new ArrayList<Integer>();
        for (int i2 = 0; i2 < keys.length; ++i2) {
            LockInfo lockInfo = (LockInfo)this.lockPool.get(keys[i2]);
            if (lockInfo == null) continue;
            if (lockInfo.getLocker().equals(locker.getName())) {
                if (lockInfo.decr() != 0) continue;
                this.lockPool.remove(keys[i2]);
                continue;
            }
            failKeyIndex.add(i2);
        }
        return failKeyIndex.stream().mapToInt(i -> i).toArray();
    }

    @Override
    protected boolean doIsLocking(String key) {
        return this.lockPool.containsKey(key);
    }

    private static class LockInfo {
        private String locker;
        private int number;

        public LockInfo(Locker locker) {
            this.locker = locker.getName();
            this.number = 1;
        }

        public String getLocker() {
            return this.locker;
        }

        public int getNumber() {
            return this.number;
        }

        public int incr() {
            return ++this.number;
        }

        public int decr() {
            --this.number;
            if (this.number < 0) {
                this.number = 0;
            }
            return this.number;
        }
    }
}

