/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.lock.utils;

import java.io.Serializable;
import java.util.Arrays;

public class StateKeys
implements Serializable {
    private String[] keys;
    private int cursor;

    public StateKeys(String[] keys) {
        this.keys = keys;
        this.cursor = 0;
    }

    public void move() {
        this.move(1L);
    }

    public void move(long n) {
        if (n <= 0L) {
            throw new IllegalArgumentException("Only positive numbers are accepted.");
        }
        if (this.cursor == -1) {
            throw new IllegalStateException("The cursor is not movable.");
        }
        this.cursor = (int)((long)this.cursor + n);
        if (this.cursor > this.keys.length - 1) {
            this.cursor = -1;
        }
    }

    public String[] getKeys() {
        return this.keys;
    }

    public String[] getNoCompleteKeys() {
        return (String[])Arrays.stream(this.keys).skip(this.cursor).toArray(String[]::new);
    }

    public String[] getCompleteKeys() {
        return Arrays.copyOfRange(this.keys, 0, this.cursor);
    }

    public int size() {
        return this.keys.length;
    }

    public String getCurrentKey() {
        return this.keys[this.cursor];
    }

    public int getCursor() {
        return this.cursor;
    }

    public boolean isComplete() {
        return this.cursor == -1;
    }

    public StateKeys copy() {
        return new StateKeys(this.keys);
    }
}

