/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.meta.connect;

import com.xforceplus.ultraman.oqsengine.meta.common.config.GRpcParams;
import com.xforceplus.ultraman.oqsengine.meta.common.proto.sync.EntityClassSyncGrpc;
import com.xforceplus.ultraman.oqsengine.meta.connect.GRpcClient;
import com.xforceplus.ultraman.oqsengine.meta.utils.ClientIdUtils;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaSyncGRpcClient
implements GRpcClient {
    private final Logger logger = LoggerFactory.getLogger(MetaSyncGRpcClient.class);
    @Resource
    private GRpcParams grpcParams;
    private ManagedChannel channel;
    private EntityClassSyncGrpc.EntityClassSyncStub stub;
    private final String host;
    private final int port;
    private boolean isClientOpen;
    private final String clientId = ClientIdUtils.generate();

    public MetaSyncGRpcClient(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public void start() {
        this.channel = ManagedChannelBuilder.forAddress((String)this.host, (int)this.port).intercept(new ClientInterceptor[]{new ClientInterceptor(){
            Metadata.Key<String> metaClientId = Metadata.Key.of((String)"clientId", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);

            public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
                return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

                    public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                        headers.put(metaClientId, (Object)MetaSyncGRpcClient.this.clientId);
                        super.start((ClientCall.Listener)new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

                            public void onHeaders(Metadata headers) {
                                super.onHeaders(headers);
                            }
                        }, headers);
                    }
                };
            }
        }}).usePlaintext().keepAliveTime(this.grpcParams.getDefaultHeartbeatTimeout(), TimeUnit.MILLISECONDS).keepAliveTimeout(this.grpcParams.getDefaultHeartbeatTimeout(), TimeUnit.MILLISECONDS).build();
        this.stub = EntityClassSyncGrpc.newStub((Channel)this.channel);
        this.logger.info("gRpc-client successfully connects to {}:{}, grpc-clientId : {}!", new Object[]{this.host, this.port, this.clientId});
        this.isClientOpen = true;
    }

    public void stop() {
        try {
            this.channel.shutdown().awaitTermination(3L, TimeUnit.SECONDS);
            this.logger.info("gRpc-client destroy!");
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            this.isClientOpen = false;
        }
    }

    @Override
    public boolean opened() {
        return this.isClientOpen;
    }

    @Override
    public EntityClassSyncGrpc.EntityClassSyncStub channelStub() {
        return this.stub;
    }
}

