/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.meta.utils;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientIdUtils {
    private static Logger LOGGER = LoggerFactory.getLogger(ClientIdUtils.class);
    private static final String DEFAULT_HOST_NAME = "OQS-ENGINE";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String generate() {
        String clientId = "";
        try {
            String hostName = System.getenv("HOSTNAME");
            InetAddress ipHost = ClientIdUtils.getInetAddress();
            if (null == ipHost) {
                if (null == hostName || hostName.isEmpty()) {
                    clientId = DEFAULT_HOST_NAME;
                }
                String string = clientId;
                return string;
            }
            if (null == hostName || hostName.isEmpty()) {
                hostName = ipHost.getHostName();
            }
            String string = clientId = hostName + "/" + ipHost.getHostAddress();
            return string;
        }
        finally {
            LOGGER.info("generate clientId : {}", (Object)clientId);
        }
    }

    private static InetAddress getInetAddress() {
        try {
            Enumeration<NetworkInterface> allNetInterfaces = NetworkInterface.getNetworkInterfaces();
            InetAddress ipHost = null;
            while (allNetInterfaces.hasMoreElements()) {
                NetworkInterface netInterface = allNetInterfaces.nextElement();
                Enumeration<InetAddress> addresses = netInterface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    ipHost = addresses.nextElement();
                    if (!(ipHost instanceof Inet4Address)) continue;
                    LOGGER.info("getInetAddress hostIp : {}, hostName : {}", (Object)ipHost.getHostAddress(), (Object)ipHost.getHostName());
                    return ipHost;
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("get clientId ip/host failed, message {}.", (Object)e.getMessage());
        }
        return null;
    }
}

