/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.meta.dto;

import com.xforceplus.ultraman.oqsengine.meta.common.dto.AbstractWatcher;
import com.xforceplus.ultraman.oqsengine.meta.common.dto.WatchElement;
import com.xforceplus.ultraman.oqsengine.meta.common.proto.sync.EntityClassSyncRequest;
import io.grpc.stub.StreamObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestWatcher
extends AbstractWatcher<EntityClassSyncRequest> {
    private final Logger logger = LoggerFactory.getLogger(RequestWatcher.class);

    public RequestWatcher(String clientId, String uid, StreamObserver<EntityClassSyncRequest> observer) {
        super(clientId, uid, observer);
    }

    public void reset(String uid, StreamObserver<EntityClassSyncRequest> streamObserver) {
        this.uid = uid;
        this.streamObserver = streamObserver;
        this.heartBeat = System.currentTimeMillis();
        this.watches().values().forEach(WatchElement::reset);
    }

    public boolean onWatch(WatchElement watchElement) {
        WatchElement v = (WatchElement)this.watches.get(watchElement.getAppId());
        if (null == v) {
            return false;
        }
        if (!watchElement.getEnv().equals(v.getEnv())) {
            this.logger.warn("current appId {}, onWatch-env {} not equals to params-env {}", new Object[]{v.getAppId(), v.getEnv(), watchElement.getEnv()});
            return false;
        }
        return v.getVersion() < watchElement.getVersion() || v.getVersion() == watchElement.getVersion() && v.getStatus().ordinal() < watchElement.getStatus().ordinal();
    }

    public boolean isAlive(String uid) {
        if (null != uid && this.isActive()) {
            try {
                return uid.equals(this.uid());
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public void release() {
        this.uid = null;
        this.releaseStreamObserver();
    }
}

