/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.meta.executor;

import com.xforceplus.ultraman.oqsengine.meta.common.dto.WatchElement;
import com.xforceplus.ultraman.oqsengine.meta.common.proto.sync.EntityClassSyncRequest;
import com.xforceplus.ultraman.oqsengine.meta.common.utils.TimeWaitUtils;
import com.xforceplus.ultraman.oqsengine.meta.dto.RequestWatcher;
import com.xforceplus.ultraman.oqsengine.meta.executor.IRequestWatchExecutor;
import io.grpc.stub.StreamObserver;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestWatchExecutor
implements IRequestWatchExecutor {
    final Logger logger = LoggerFactory.getLogger(RequestWatchExecutor.class);
    private RequestWatcher requestWatcher;

    public void resetHeartBeat(String uid) {
        this.requestWatcher.resetHeartBeat();
    }

    public void release(String uid) {
        if (null != this.requestWatcher) {
            this.requestWatcher.release();
        }
    }

    @Override
    public void create(String clientId, String uid, StreamObserver<EntityClassSyncRequest> observer) {
        if (null == this.requestWatcher) {
            this.requestWatcher = new RequestWatcher(clientId, uid, observer);
        } else {
            this.requestWatcher.reset(uid, observer);
        }
    }

    @Override
    public void add(WatchElement watchElement, boolean isReset) {
        if (null != this.requestWatcher) {
            this.requestWatcher.addWatch(watchElement, isReset);
        }
    }

    @Override
    public synchronized boolean update(WatchElement watchElement) {
        if (null != this.requestWatcher && this.requestWatcher.onWatch(watchElement)) {
            this.requestWatcher.watches().put(watchElement.getAppId(), watchElement);
            return true;
        }
        return false;
    }

    @Override
    public RequestWatcher watcher() {
        return this.requestWatcher;
    }

    @Override
    public void active() {
        if (null != this.requestWatcher) {
            this.requestWatcher.active();
        }
    }

    @Override
    public void inActive() {
        if (null != this.requestWatcher) {
            this.requestWatcher.inActive();
        }
    }

    @Override
    public boolean isAlive(String uid) {
        if (null == this.requestWatcher) {
            return false;
        }
        return this.requestWatcher.isAlive(uid);
    }

    public void start() {
        this.logger.debug("requestWatchExecutor start.");
    }

    public void stop() {
        if (null != this.requestWatcher) {
            this.requestWatcher.inActive();
            TimeWaitUtils.wakeupAfter((long)3L, (TimeUnit)TimeUnit.SECONDS);
            this.requestWatcher.release();
        }
        this.logger.info("requestWatchExecutor stop.");
    }
}

