/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.meta.handler;

import com.xforceplus.ultraman.oqsengine.meta.common.config.GRpcParams;
import com.xforceplus.ultraman.oqsengine.meta.common.constant.RequestStatus;
import com.xforceplus.ultraman.oqsengine.meta.common.dto.WatchElement;
import com.xforceplus.ultraman.oqsengine.meta.common.exception.MetaSyncClientException;
import com.xforceplus.ultraman.oqsengine.meta.common.monitor.MetricsRecorder;
import com.xforceplus.ultraman.oqsengine.meta.common.monitor.dto.SyncCode;
import com.xforceplus.ultraman.oqsengine.meta.common.proto.sync.EntityClassSyncRequest;
import com.xforceplus.ultraman.oqsengine.meta.common.proto.sync.EntityClassSyncResponse;
import com.xforceplus.ultraman.oqsengine.meta.common.proto.sync.EntityClassSyncRspProto;
import com.xforceplus.ultraman.oqsengine.meta.common.utils.MD5Utils;
import com.xforceplus.ultraman.oqsengine.meta.common.utils.ThreadUtils;
import com.xforceplus.ultraman.oqsengine.meta.common.utils.TimeWaitUtils;
import com.xforceplus.ultraman.oqsengine.meta.dto.RequestWatcher;
import com.xforceplus.ultraman.oqsengine.meta.executor.IRequestWatchExecutor;
import com.xforceplus.ultraman.oqsengine.meta.handler.IRequestHandler;
import com.xforceplus.ultraman.oqsengine.meta.provider.outter.SyncExecutor;
import com.xforceplus.ultraman.oqsengine.meta.utils.SendUtils;
import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncRequestHandler
implements IRequestHandler {
    private Logger logger = LoggerFactory.getLogger(SyncRequestHandler.class);
    @Resource(name="grpcSyncExecutor")
    private SyncExecutor syncExecutor;
    @Resource
    private IRequestWatchExecutor requestWatchExecutor;
    @Resource
    private GRpcParams grpcParams;
    @Resource(name="grpcTaskExecutor")
    private ExecutorService executorService;
    @Resource
    private MetricsRecorder metricsRecorder;
    private Queue<WatchElement> forgotQueue = new ConcurrentLinkedDeque<WatchElement>();
    private List<Thread> longRunTasks = new ArrayList<Thread>(2);
    private volatile boolean isShutdown = false;
    private static final int PRINT_CHECK_DURATION = 10;

    public void start() {
        this.isShutdown = false;
        this.longRunTasks.add(ThreadUtils.create(this::keepAlive));
        this.longRunTasks.add(ThreadUtils.create(this::watchElementCheck));
        this.longRunTasks.forEach(Thread::start);
        this.logger.info("requestWatchExecutor start.");
    }

    public void stop() {
        this.isShutdown = true;
        this.requestWatchExecutor.stop();
    }

    @Override
    public synchronized boolean register(WatchElement watchElement) {
        RequestWatcher watcher = this.requestWatchExecutor.watcher();
        if (null == watcher) {
            this.logger.warn("current gRpc-client is not init, can't offer appIds:{}.", (Object)watchElement);
            this.addToForgotQueue(watchElement);
            return false;
        }
        WatchElement w = (WatchElement)watcher.watches().get(watchElement.getAppId());
        if (null != w) {
            if (!w.getEnv().equals(watchElement.getEnv())) {
                this.metricsRecorder.error(w.getAppId(), SyncCode.REGISTER_ERROR.name(), String.format("can't register same appId [%s] with another env [%s], env [%s] already registered.", w.getAppId(), watchElement.getEnv(), w.getEnv()));
                return false;
            }
            if (watchElement.getVersion() == -1 || watchElement.getVersion() > w.getVersion()) {
                if (!this.send(watcher.clientId(), watcher.uid(), true, true, RequestStatus.REGISTER, watchElement)) {
                    this.metricsRecorder.error(w.getAppId(), SyncCode.REGISTER_ERROR.name(), String.format("send register failed, exist watchElement, env %s", w.getEnv()));
                    return false;
                }
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug("current watchList has this watchElement, appId [{}], ignore register...", (Object)watchElement.getAppId());
            }
        } else if (!this.requestWatchExecutor.isAlive(watcher.uid())) {
            this.addToForgotQueue(watchElement);
        } else if (!this.send(watcher.clientId(), watcher.uid(), false, true, RequestStatus.REGISTER, watchElement)) {
            this.metricsRecorder.error(watchElement.getAppId(), SyncCode.REGISTER_ERROR.name(), String.format("send register failed, env %s", watchElement.getEnv()));
            return false;
        }
        return true;
    }

    @Override
    public boolean reRegister() {
        RequestWatcher requestWatcher = this.requestWatchExecutor.watcher();
        if (null != requestWatcher && requestWatcher.watches().size() > 0) {
            for (Map.Entry e : requestWatcher.watches().entrySet()) {
                if (!this.send(requestWatcher.clientId(), requestWatcher.uid(), false, false, RequestStatus.REGISTER, (WatchElement)e.getValue())) {
                    String error = String.format("reRegister failed, env : %s", ((WatchElement)e.getValue()).getEnv());
                    this.metricsRecorder.error(((WatchElement)e.getValue()).getAppId(), SyncCode.REGISTER_ERROR.name(), error);
                    requestWatcher.observer().onError(new Throwable(error));
                    return false;
                }
                ((WatchElement)e.getValue()).setRegisterTime(System.currentTimeMillis());
                this.logger.info("reRegister success uid [{}], appId [{}], env [{}], version [{}].", new Object[]{requestWatcher.uid(), e.getKey(), ((WatchElement)e.getValue()).getEnv(), ((WatchElement)e.getValue()).getVersion()});
            }
        }
        return true;
    }

    @Override
    public void initWatcher(String clientId, String uid, StreamObserver<EntityClassSyncRequest> streamObserver) {
        this.requestWatchExecutor.create(clientId, uid, streamObserver);
    }

    public void invoke(EntityClassSyncResponse entityClassSyncResponse, Void nil) {
        this.requestWatchExecutor.resetHeartBeat(entityClassSyncResponse.getUid());
        if (entityClassSyncResponse.getStatus() == RequestStatus.REGISTER_OK.ordinal()) {
            boolean ret = this.requestWatchExecutor.update(new WatchElement(entityClassSyncResponse.getAppId(), entityClassSyncResponse.getEnv(), entityClassSyncResponse.getVersion(), WatchElement.ElementStatus.Confirmed));
            if (ret) {
                this.metricsRecorder.info(entityClassSyncResponse.getAppId(), SyncCode.REGISTER_OK.name(), String.format("register success, uid : %s, env : %s, version : %s success.", entityClassSyncResponse.getUid(), entityClassSyncResponse.getEnv(), entityClassSyncResponse.getVersion()));
            }
        } else if (entityClassSyncResponse.getStatus() == RequestStatus.SYNC.ordinal()) {
            this.executorService.submit(() -> {
                block2: {
                    try {
                        this.accept(entityClassSyncResponse);
                    }
                    catch (Exception e) {
                        if (!this.requestWatchExecutor.watcher().isActive()) break block2;
                        this.requestWatchExecutor.watcher().observer().onError((Throwable)e);
                    }
                }
            });
        }
    }

    @Override
    public MetricsRecorder metricsRecorder() {
        return this.metricsRecorder;
    }

    public boolean isShutDown() {
        return this.isShutdown;
    }

    @Override
    public IRequestWatchExecutor watchExecutor() {
        return this.requestWatchExecutor;
    }

    @Override
    public void notReady() {
        this.requestWatchExecutor.inActive();
        if (this.isShutdown) {
            this.logger.warn("stream has broken due to client has been shutdown...");
        } else {
            String uid = null != this.requestWatchExecutor.watcher() ? this.requestWatchExecutor.watcher().uid() : "unKnow-stream";
            this.logger.warn("stream [{}] has broken, reCreate new stream after ({})ms...", (Object)uid, (Object)this.grpcParams.getReconnectDuration());
            TimeWaitUtils.wakeupAfter((long)this.grpcParams.getReconnectDuration(), (TimeUnit)TimeUnit.MILLISECONDS);
            this.requestWatchExecutor.release(uid);
        }
    }

    @Override
    public void ready() {
        this.requestWatchExecutor.active();
    }

    @Override
    public boolean reset(WatchElement watchElement) {
        WatchElement old = (WatchElement)this.requestWatchExecutor.watcher().watches().get(watchElement.getAppId());
        try {
            watchElement.setStatus(WatchElement.ElementStatus.Register);
            this.requestWatchExecutor.add(watchElement, true);
            return this.send(this.requestWatchExecutor.watcher().clientId(), this.requestWatchExecutor.watcher().uid(), false, true, RequestStatus.RESET, watchElement);
        }
        catch (Exception e) {
            this.requestWatchExecutor.add(old, true);
            this.metricsRecorder.error(watchElement.getAppId(), SyncCode.RESET_ENV_ERROR.name(), String.format("reset failed, env : %s, cause : %s", watchElement.getEnv(), e.getMessage()));
            return false;
        }
    }

    private boolean send(String clientId, String uid, boolean force, boolean checkActive, RequestStatus requestStatus, WatchElement v) {
        EntityClassSyncRequest.Builder builder = EntityClassSyncRequest.newBuilder();
        EntityClassSyncRequest entityClassSyncRequest = builder.setUid(uid).setAppId(v.getAppId()).setEnv(v.getEnv()).setVersion(v.getVersion()).setForce(force).setStatus(requestStatus.ordinal()).setClientId(clientId).build();
        this.requestWatchExecutor.add(v, false);
        try {
            SendUtils.sendRequest(this.requestWatchExecutor.watcher(), entityClassSyncRequest, checkActive);
            this.logger.info("register success uid [{}], appId [{}], env [{}], version [{}].", new Object[]{uid, v.getAppId(), v.getEnv(), v.getVersion()});
            return true;
        }
        catch (Exception e) {
            v.setStatus(WatchElement.ElementStatus.Init);
            return false;
        }
    }

    private void accept(EntityClassSyncResponse entityClassSyncResponse) {
        EntityClassSyncRequest.Builder entityClassSyncRequestBuilder;
        try {
            entityClassSyncRequestBuilder = this.execute(entityClassSyncResponse);
        }
        catch (Exception e) {
            entityClassSyncRequestBuilder = EntityClassSyncRequest.newBuilder().setStatus(RequestStatus.SYNC_FAIL.ordinal());
            this.metricsRecorder.error(entityClassSyncResponse.getAppId(), SyncCode.SYNC_DATA_ERROR.name(), String.format("parse sync-data failed, env :%s, version : %s, cause : %s", entityClassSyncResponse.getEnv(), entityClassSyncResponse.getVersion(), e.getMessage()));
        }
        if (null != entityClassSyncRequestBuilder) {
            if (!entityClassSyncResponse.getForce()) {
                EntityClassSyncRequest entityClassSyncRequest = entityClassSyncRequestBuilder.setClientId(this.requestWatchExecutor.watcher().clientId()).setUid(entityClassSyncResponse.getUid()).build();
                try {
                    SendUtils.sendRequest(this.requestWatchExecutor.watcher(), entityClassSyncRequest, true);
                }
                catch (Exception e) {
                    this.metricsRecorder.error(entityClassSyncRequest.getAppId(), SyncCode.SEND_REQUEST_ERROR.name(), String.format("send sync result failed, env :%s, version : %s, cause : %s", entityClassSyncResponse.getEnv(), entityClassSyncResponse.getVersion(), e.getMessage()));
                    throw e;
                }
            }
            if (entityClassSyncRequestBuilder.getStatus() == RequestStatus.SYNC_OK.ordinal()) {
                this.metricsRecorder.info(entityClassSyncResponse.getAppId(), SyncCode.SYNC_DATA_OK.name(), String.format("sync-data ok, uid : %s, env : %s, version : %s", entityClassSyncResponse.getUid(), entityClassSyncResponse.getEnv(), entityClassSyncResponse.getVersion()));
            }
        }
    }

    private EntityClassSyncRequest.Builder execute(EntityClassSyncResponse entityClassSyncResponse) {
        EntityClassSyncRequest.Builder builder = EntityClassSyncRequest.newBuilder();
        if (entityClassSyncResponse.getAppId().isEmpty() || entityClassSyncResponse.getAppId().isEmpty() || -1 == entityClassSyncResponse.getVersion()) {
            throw new MetaSyncClientException("appId/version/env could not be null...", false);
        }
        builder.setAppId(entityClassSyncResponse.getAppId()).setVersion(entityClassSyncResponse.getVersion()).setEnv(entityClassSyncResponse.getEnv());
        EntityClassSyncRspProto result = entityClassSyncResponse.getEntityClassSyncRspProto();
        if (this.md5Check(entityClassSyncResponse.getMd5(), result)) {
            WatchElement w = new WatchElement(entityClassSyncResponse.getAppId(), entityClassSyncResponse.getEnv(), entityClassSyncResponse.getVersion(), WatchElement.ElementStatus.Confirmed);
            if (entityClassSyncResponse.getForce() || this.requestWatchExecutor.watcher().onWatch(w)) {
                boolean needReturnResult = false;
                try {
                    needReturnResult = this.syncExecutor.sync(entityClassSyncResponse.getAppId(), entityClassSyncResponse.getEnv(), entityClassSyncResponse.getVersion(), result);
                }
                catch (Exception e) {
                    throw new MetaSyncClientException(e.getMessage(), false);
                }
                if (!needReturnResult) {
                    return null;
                }
                this.requestWatchExecutor.update(w);
            } else {
                this.logger.debug(String.format("sync data error, current oqs not watch this version or sync version is less than service-version, env : %s, version : %s", entityClassSyncResponse.getEnv(), entityClassSyncResponse.getVersion()));
            }
        } else {
            throw new MetaSyncClientException("checkMD5 failed.", false);
        }
        return builder.setStatus(RequestStatus.SYNC_OK.ordinal());
    }

    private boolean md5Check(String md5, EntityClassSyncRspProto entityClassSyncRspProto) {
        if (null == md5 || md5.isEmpty() || null == entityClassSyncRspProto) {
            return false;
        }
        return md5.equals(MD5Utils.getMD5((byte[])entityClassSyncRspProto.toByteArray()));
    }

    private boolean keepAlive() {
        this.logger.debug("start keepAlive task ok...");
        while (!this.isShutDown()) {
            RequestWatcher requestWatcher = this.requestWatchExecutor.watcher();
            if (null != requestWatcher) {
                try {
                    if (requestWatcher.isActive() && System.currentTimeMillis() - requestWatcher.heartBeat() > this.grpcParams.getDefaultHeartbeatTimeout()) {
                        requestWatcher.observer().onCompleted();
                        this.logger.warn("last heartbeat time [{}] reaches max timeout [{}]", (Object)(System.currentTimeMillis() - requestWatcher.heartBeat()), (Object)this.grpcParams.getDefaultHeartbeatTimeout());
                    }
                    EntityClassSyncRequest request = EntityClassSyncRequest.newBuilder().setClientId(requestWatcher.clientId()).setUid(requestWatcher.uid()).setStatus(RequestStatus.HEARTBEAT.ordinal()).build();
                    SendUtils.sendRequest(requestWatcher, request, true);
                }
                catch (Exception e) {
                    this.logger.warn("send keepAlive failed, message [{}], but exception will ignore due to retry...", (Object)e.getMessage());
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("keepAlive ok, print next check after ({})ms...", (Object)this.grpcParams.getKeepAliveSendDuration());
                }
            }
            TimeWaitUtils.wakeupAfter((long)this.grpcParams.getKeepAliveSendDuration(), (TimeUnit)TimeUnit.MILLISECONDS);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("keepAlive task has quited due to sync-client shutdown...");
        }
        return true;
    }

    private boolean watchElementCheck() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("start appCheck task ok...");
        }
        long counter = 0L;
        while (!this.isShutDown()) {
            RequestWatcher requestWatcher = this.requestWatchExecutor.watcher();
            if (null != requestWatcher && requestWatcher.isActive()) {
                for (int checkSize = this.forgotQueue.size(); checkSize > 0; --checkSize) {
                    try {
                        WatchElement w = this.forgotQueue.remove();
                        if (requestWatcher.watches().containsKey(w.getAppId())) continue;
                        requestWatcher.watches().put(w.getAppId(), w);
                        continue;
                    }
                    catch (Exception e) {
                        break;
                    }
                }
                requestWatcher.watches().values().stream().filter(s -> s.getStatus().ordinal() == WatchElement.ElementStatus.Init.ordinal() || s.getStatus().ordinal() < WatchElement.ElementStatus.Confirmed.ordinal() && System.currentTimeMillis() - s.getRegisterTime() > this.grpcParams.getDefaultDelayTaskDuration()).forEach(k -> {
                    EntityClassSyncRequest.Builder builder = EntityClassSyncRequest.newBuilder();
                    EntityClassSyncRequest entityClassSyncRequest = builder.setUid(requestWatcher.uid()).setClientId(requestWatcher.clientId()).setAppId(k.getAppId()).setEnv(k.getEnv()).setVersion(k.getVersion()).setStatus(RequestStatus.REGISTER.ordinal()).build();
                    try {
                        SendUtils.sendRequest(requestWatcher, entityClassSyncRequest, true);
                        k.setRegisterTime(System.currentTimeMillis());
                    }
                    catch (Exception e) {
                        k.setStatus(WatchElement.ElementStatus.Init);
                    }
                });
                if (counter % 10L == 0L && this.logger.isDebugEnabled()) {
                    this.logger.debug("app check ok, print next check after ({})ms...", (Object)(this.grpcParams.getMonitorSleepDuration() * 10L));
                }
                ++counter;
            }
            TimeWaitUtils.wakeupAfter((long)this.grpcParams.getMonitorSleepDuration(), (TimeUnit)TimeUnit.MILLISECONDS);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("appCheck task has quited due to sync-client shutdown...");
        }
        return true;
    }

    public Queue<WatchElement> getForgotQueue() {
        return this.forgotQueue;
    }

    private void addToForgotQueue(WatchElement watchElement) {
        if (this.forgotQueue.stream().noneMatch(arg_0 -> ((WatchElement)watchElement).logicEquals(arg_0))) {
            this.forgotQueue.add(watchElement);
        }
    }
}

