/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.meta.utils;

import com.xforceplus.ultraman.oqsengine.meta.common.constant.RequestStatus;
import com.xforceplus.ultraman.oqsengine.meta.common.exception.MetaSyncClientException;
import com.xforceplus.ultraman.oqsengine.meta.common.proto.sync.EntityClassSyncRequest;
import com.xforceplus.ultraman.oqsengine.meta.dto.RequestWatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(SendUtils.class);

    public static void sendRequest(RequestWatcher requestWatcher, EntityClassSyncRequest entityClassSyncRequest, boolean checkActive) {
        if (null == requestWatcher || checkActive && !requestWatcher.isActive()) {
            LOGGER.warn("stream observer not exists.");
            throw new MetaSyncClientException("stream observer not exists or was expired.", true);
        }
        try {
            requestWatcher.observer().onNext((Object)entityClassSyncRequest);
            SendUtils.printLog(entityClassSyncRequest);
        }
        catch (Exception e) {
            throw new MetaSyncClientException(String.format("send request error, message-[%s].", e.getMessage()), true);
        }
    }

    private static void printLog(EntityClassSyncRequest entityClassSyncRequest) {
        try {
            RequestStatus requestStatus = RequestStatus.getInstance((int)entityClassSyncRequest.getStatus());
            if (entityClassSyncRequest.getStatus() == RequestStatus.HEARTBEAT.ordinal()) {
                LOGGER.debug("send request success, request [{}, {}, {}]", new Object[]{"HEARTBEAT", "STATUS:" + (null == requestStatus ? "UN_KNOW" : requestStatus.name()), "UID:" + entityClassSyncRequest.getUid()});
            } else {
                String appId = entityClassSyncRequest.getAppId();
                LOGGER.debug("send request success, request [{}, {}, {}, {}, {}]", new Object[]{"REQ APP_ID:" + appId, "ENV:" + entityClassSyncRequest.getEnv(), "VER:" + entityClassSyncRequest.getVersion(), "STATUS:" + (null == requestStatus ? "UN_KNOW" : requestStatus.name()), "UID:" + entityClassSyncRequest.getUid()});
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

