/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.meta.common.monitor;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.xforceplus.ultraman.oqsengine.meta.common.monitor.MetricsRecorder;
import com.xforceplus.ultraman.oqsengine.meta.common.monitor.dto.MetricsLog;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedMetricsRecorder
implements MetricsRecorder {
    final Logger logger = LoggerFactory.getLogger(CachedMetricsRecorder.class);
    private Cache<String, Map<String, MetricsLog.Message>> syncLogs;
    private Cache<String, Map<String, MetricsLog.Message>> errorLogs;
    private static final int DEFAULT_MAX_CACHE_SIZE = 1024;
    private static final int DEFAULT_CACHE_EXPIRE = 604800;

    public CachedMetricsRecorder() {
        this(1024, 604800);
    }

    public CachedMetricsRecorder(int maxCacheSize, int cacheExpire) {
        if (0 >= maxCacheSize) {
            maxCacheSize = 1024;
        }
        if (0 >= cacheExpire) {
            cacheExpire = 604800;
        }
        this.syncLogs = CacheBuilder.newBuilder().maximumSize((long)maxCacheSize).expireAfterWrite((long)cacheExpire, TimeUnit.SECONDS).build();
        this.errorLogs = CacheBuilder.newBuilder().maximumSize((long)maxCacheSize).expireAfterWrite((long)cacheExpire, TimeUnit.SECONDS).build();
    }

    @Override
    public void error(String key, String code, String message) {
        this.logger.warn("code: {}, key: {}, message: {}", new Object[]{code, key, message});
        try {
            Map r = (Map)this.errorLogs.get((Object)key, LinkedHashMap::new);
            r.put(code, new MetricsLog.Message(message));
        }
        catch (ExecutionException e) {
            this.logger.warn("record message error.");
        }
    }

    @Override
    public void info(String key, String code, String message) {
        this.logger.info("code: {}, key: {}, message: {}", new Object[]{code, key, message});
        try {
            Map r = (Map)this.syncLogs.get((Object)key, LinkedHashMap::new);
            r.put(code, new MetricsLog.Message(message));
        }
        catch (ExecutionException e) {
            this.logger.warn("record message error.");
        }
    }

    @Override
    public List<MetricsLog> showLogs(MetricsLog.ShowType showType) {
        if (null != showType) {
            switch (showType) {
                case INFO: {
                    return MetricsLog.toMetricsLogs(this.syncLogs.asMap());
                }
                case ERROR: {
                    return MetricsLog.toMetricsLogs(this.errorLogs.asMap());
                }
            }
        }
        ArrayList<MetricsLog> metricsLogs = new ArrayList<MetricsLog>();
        metricsLogs.addAll(MetricsLog.toMetricsLogs(this.syncLogs.asMap()));
        metricsLogs.addAll(MetricsLog.toMetricsLogs(this.errorLogs.asMap()));
        return metricsLogs;
    }
}

