/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.meta.common.utils;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class ExecutorHelper {
    private ExecutorHelper() {
    }

    public static void shutdownAndAwaitTermination(ExecutorService pool) {
        ExecutorHelper.shutdownAndAwaitTermination(pool, 60L);
    }

    public static void shutdownAndAwaitTermination(ExecutorService pool, long timeout) {
        pool.shutdown();
        try {
            if (!pool.awaitTermination(timeout, TimeUnit.SECONDS)) {
                pool.shutdownNow();
                if (!pool.awaitTermination(timeout, TimeUnit.SECONDS)) {
                    System.err.println("Pool did not terminate.");
                }
            }
        }
        catch (InterruptedException ie) {
            pool.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public static ThreadFactory buildNameThreadFactory(String name) {
        return ExecutorHelper.buildNameThreadFactory(name, false);
    }

    public static ThreadFactory buildNameThreadFactory(final String name, final boolean daemon) {
        return new ThreadFactory(){
            private final AtomicLong number = new AtomicLong();

            @Override
            public Thread newThread(Runnable r) {
                Thread newThread = Executors.defaultThreadFactory().newThread(r);
                newThread.setName(name + "-" + this.number.getAndIncrement());
                newThread.setDaemon(daemon);
                return newThread;
            }
        };
    }

    public static ExecutorService buildThreadPool(int worker, int queue, String namePrefix, boolean daemon) {
        return new ThreadPoolExecutor(worker, worker, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(queue), ExecutorHelper.buildNameThreadFactory(namePrefix, daemon), new ThreadPoolExecutor.AbortPolicy());
    }
}

