/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.meta.common.dto;

import com.xforceplus.ultraman.oqsengine.meta.common.dto.IWatcher;
import com.xforceplus.ultraman.oqsengine.meta.common.dto.WatchElement;
import io.grpc.stub.StreamObserver;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWatcher<T>
implements IWatcher<T> {
    private final Logger logger = LoggerFactory.getLogger(AbstractWatcher.class);
    protected volatile String clientId;
    protected volatile String uid;
    protected volatile long heartBeat;
    protected volatile StreamObserver<T> streamObserver;
    protected Map<String, WatchElement> watches;
    private volatile boolean isActive = true;

    public AbstractWatcher(String clientId, String uid, StreamObserver<T> streamObserver) {
        this.clientId = clientId;
        this.uid = uid;
        this.streamObserver = streamObserver;
        this.heartBeat = System.currentTimeMillis();
        this.watches = new ConcurrentHashMap<String, WatchElement>();
    }

    @Override
    public String clientId() {
        return this.clientId;
    }

    @Override
    public void addWatch(WatchElement w, boolean isReset) {
        if (isReset) {
            this.watches.put(w.getAppId(), w);
        } else {
            this.watches.putIfAbsent(w.getAppId(), w);
        }
    }

    @Override
    public String uid() {
        return this.uid;
    }

    @Override
    public long heartBeat() {
        return this.heartBeat;
    }

    @Override
    public void resetHeartBeat() {
        if (this.isActive) {
            this.heartBeat = System.currentTimeMillis();
        }
    }

    @Override
    public <S> void release(Supplier<S> supplier) {
        this.inActive();
        try {
            supplier.get();
        }
        catch (Exception exception) {
        }
        finally {
            this.release();
        }
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public Map<String, WatchElement> watches() {
        return this.watches;
    }

    @Override
    public boolean runWithCheck(Function<StreamObserver<T>, Boolean> function) {
        if (this.isActive) {
            return function.apply(this.streamObserver);
        }
        this.logger.warn("uid [{}], offServe...", (Object)this.uid);
        return false;
    }

    @Override
    public StreamObserver<T> observer() {
        return this.streamObserver;
    }

    protected abstract void reset(String var1, StreamObserver<T> var2);

    protected void releaseStreamObserver() {
        try {
            if (null != this.streamObserver) {
                this.streamObserver.onCompleted();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void active() {
        this.isActive = true;
        this.resetHeartBeat();
    }

    @Override
    public void inActive() {
        this.isActive = false;
    }
}

