/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.meta.common.monitor.dto;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class MetricsLog {
    private String appId;
    private String clientId;
    private String code;
    private Message message;
    public static final String LINK = "__";

    public MetricsLog(String appId, String code, Message message) {
        this.appId = appId;
        this.code = code;
        this.message = message;
    }

    public MetricsLog(String appId, String clientId, String code, Message message) {
        this.appId = appId;
        this.clientId = clientId;
        this.code = code;
        this.message = message;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public Message getMessage() {
        return this.message;
    }

    public static List<MetricsLog> toMetricsLogs(Map<String, Map<String, Message>> raw) {
        ArrayList<MetricsLog> metricsLogs = new ArrayList<MetricsLog>();
        raw.forEach((key, value) -> value.forEach((code, error) -> {
            String[] sp;
            MetricsLog metricsLog = code.contains(LINK) ? ((sp = code.split(LINK)).length > 1 ? new MetricsLog((String)key, sp[0], sp[1], (Message)error) : new MetricsLog((String)key, (String)code, (Message)error)) : new MetricsLog((String)key, (String)code, (Message)error);
            metricsLogs.add(metricsLog);
        }));
        return metricsLogs;
    }

    public static String linkKey(String ... keys) {
        if (null == keys || 0 == keys.length) {
            return "";
        }
        if (1 == keys.length) {
            return keys[0];
        }
        return String.join((CharSequence)LINK, keys);
    }

    public static class Message {
        private long timeStamp;
        private String message;

        public Message(String message) {
            this.message = message;
            this.timeStamp = System.currentTimeMillis();
        }

        public long getTimeStamp() {
            return this.timeStamp;
        }

        public String getMessage() {
            return this.message;
        }
    }

    public static enum ShowType {
        ALL,
        INFO,
        ERROR;


        public static ShowType getInstance(String type) {
            if (null != type) {
                for (ShowType showType : ShowType.values()) {
                    if (!showType.name().equals(type.toUpperCase())) continue;
                    return showType;
                }
            }
            return ALL;
        }
    }
}

