/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.meta;

import com.xforceplus.ultraman.oqsengine.meta.common.executor.IBasicSyncExecutor;
import com.xforceplus.ultraman.oqsengine.meta.common.proto.sync.EntityClassSyncGrpc;
import com.xforceplus.ultraman.oqsengine.meta.common.proto.sync.EntityClassSyncRequest;
import com.xforceplus.ultraman.oqsengine.meta.common.proto.sync.EntityClassSyncResponse;
import com.xforceplus.ultraman.oqsengine.meta.handler.IResponseHandler;
import io.grpc.stub.StreamObserver;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityClassSyncServer
extends EntityClassSyncGrpc.EntityClassSyncImplBase
implements IBasicSyncExecutor {
    private final Logger logger = LoggerFactory.getLogger(EntityClassSyncServer.class);
    @Resource
    private IResponseHandler responseHandler;

    public void start() {
        this.responseHandler.start();
        this.logger.debug("entityClassSyncServer start.");
    }

    public void stop() {
        this.responseHandler.stop();
        this.logger.debug("entityClassSyncServer stop.");
    }

    public StreamObserver<EntityClassSyncRequest> register(final StreamObserver<EntityClassSyncResponse> responseStreamObserver) {
        return new StreamObserver<EntityClassSyncRequest>(){

            public void onNext(EntityClassSyncRequest entityClassSyncRequest) {
                EntityClassSyncServer.this.responseHandler.invoke(entityClassSyncRequest, responseStreamObserver);
            }

            public void onError(Throwable throwable) {
                EntityClassSyncServer.this.logger.warn("response terminate onError, message :{}", (Object)throwable.getMessage());
            }

            public void onCompleted() {
                EntityClassSyncServer.this.logger.info("response terminate onCompleted");
                responseStreamObserver.onCompleted();
            }
        };
    }
}

