/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.meta.connect;

import com.xforceplus.ultraman.oqsengine.meta.EntityClassSyncServer;
import com.xforceplus.ultraman.oqsengine.meta.common.config.GRpcParams;
import com.xforceplus.ultraman.oqsengine.meta.common.executor.IBasicSyncExecutor;
import com.xforceplus.ultraman.oqsengine.meta.common.utils.ThreadUtils;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.netty.NettyServerBuilder;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GRpcServer
implements IBasicSyncExecutor {
    private final Logger logger = LoggerFactory.getLogger(GRpcServer.class);
    @Resource(name="grpcServerExecutor")
    private ExecutorService grpcExecutor;
    @Resource
    private EntityClassSyncServer entityClassSyncServer;
    @Resource
    private GRpcParams configuration;
    @Resource(name="outerBindingService")
    private List<BindableService> outerServiceList;
    private final int port;
    private Server grpcServer;

    public GRpcServer(int port) {
        this.port = port;
    }

    @PostConstruct
    public void start() {
        this.entityClassSyncServer.start();
        try {
            this.grpcServer = this.serverBuilder().build().start();
        }
        catch (IOException e) {
            this.logger.info("gRpcServer start failed, message : {}", (Object)e.getMessage());
            System.exit(-1);
        }
        this.awaitForTerminationThread();
        this.logger.info("gRpcServer start ok on port {}.", (Object)this.port);
    }

    public void stop() {
        this.entityClassSyncServer.stop();
        this.destroy();
    }

    private void destroy() {
        Optional.ofNullable(this.grpcServer.isShutdown() ? null : this.grpcServer).ifPresent(Server::shutdown);
        this.logger.info("gRPC server stopped.");
    }

    private void awaitForTerminationThread() {
        Thread serverThread = ThreadUtils.create(() -> {
            try {
                this.grpcServer.awaitTermination();
            }
            catch (InterruptedException e) {
                this.logger.warn("gRPC server stopped failed, {}", (Object)e.getMessage());
            }
            return true;
        });
        serverThread.setDaemon(false);
        serverThread.start();
    }

    private ServerBuilder serverBuilder() {
        this.logger.info("server build start...");
        NettyServerBuilder serverBuilder = ((NettyServerBuilder)((NettyServerBuilder)NettyServerBuilder.forPort((int)this.port).executor((Executor)this.grpcExecutor)).addService((BindableService)this.entityClassSyncServer)).maxInboundMetadataSize(8192).maxInboundMessageSize(0x400000).keepAliveTime(this.configuration.getDefaultHeartbeatTimeout(), TimeUnit.MILLISECONDS).keepAliveTimeout(this.configuration.getDefaultHeartbeatTimeout(), TimeUnit.MILLISECONDS).permitKeepAliveWithoutCalls(true).permitKeepAliveTime(1L, TimeUnit.SECONDS);
        if (null != this.outerServiceList) {
            this.outerServiceList.forEach(arg_0 -> this.lambda$serverBuilder$1((ServerBuilder)serverBuilder, arg_0));
        }
        this.logger.info("server build ok...");
        return serverBuilder;
    }

    private /* synthetic */ void lambda$serverBuilder$1(ServerBuilder serverBuilder, BindableService o) {
        serverBuilder.addService(o);
        this.logger.info("server build, add outerService [{}]", (Object)o.getClass().getCanonicalName());
    }
}

