/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.meta.handler;

import com.xforceplus.ultraman.oqsengine.meta.common.config.GRpcParams;
import com.xforceplus.ultraman.oqsengine.meta.common.constant.RequestStatus;
import com.xforceplus.ultraman.oqsengine.meta.common.dto.WatchElement;
import com.xforceplus.ultraman.oqsengine.meta.common.exception.Code;
import com.xforceplus.ultraman.oqsengine.meta.common.exception.MetaSyncServerException;
import com.xforceplus.ultraman.oqsengine.meta.common.executor.IDelayTaskExecutor;
import com.xforceplus.ultraman.oqsengine.meta.common.proto.sync.EntityClassSyncRequest;
import com.xforceplus.ultraman.oqsengine.meta.common.proto.sync.EntityClassSyncResponse;
import com.xforceplus.ultraman.oqsengine.meta.common.proto.sync.EntityClassSyncRspProto;
import com.xforceplus.ultraman.oqsengine.meta.common.utils.MD5Utils;
import com.xforceplus.ultraman.oqsengine.meta.common.utils.ThreadUtils;
import com.xforceplus.ultraman.oqsengine.meta.common.utils.TimeWaitUtils;
import com.xforceplus.ultraman.oqsengine.meta.dto.AppUpdateEvent;
import com.xforceplus.ultraman.oqsengine.meta.dto.ResponseWatcher;
import com.xforceplus.ultraman.oqsengine.meta.executor.IResponseWatchExecutor;
import com.xforceplus.ultraman.oqsengine.meta.executor.RetryExecutor;
import com.xforceplus.ultraman.oqsengine.meta.handler.IResponseHandler;
import com.xforceplus.ultraman.oqsengine.meta.provider.outter.EntityClassGenerator;
import io.grpc.stub.StreamObserver;
import io.micrometer.core.instrument.Metrics;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncResponseHandler
implements IResponseHandler {
    private final Logger logger = LoggerFactory.getLogger(SyncResponseHandler.class);
    @Resource
    private IResponseWatchExecutor responseWatchExecutor;
    @Resource
    private IDelayTaskExecutor<RetryExecutor.DelayTask> retryExecutor;
    @Resource
    private EntityClassGenerator entityClassGenerator;
    @Resource(name="grpcTaskExecutor")
    private ExecutorService taskExecutor;
    @Resource
    private GRpcParams grpcParams;
    private final List<Thread> longRunTasks = new ArrayList<Thread>(2);
    private volatile boolean isShutdown = false;
    private final AtomicInteger dataHandleFailedCounter = (AtomicInteger)Metrics.gauge((String)"oqs.connector.server.handle-failed-error", (Number)new AtomicInteger(0));
    private final AtomicInteger dataFormatErrorCounter = (AtomicInteger)Metrics.gauge((String)"oqs.connector.server.data-format-error", (Number)new AtomicInteger(0));

    public void start() {
        this.isShutdown = false;
        this.retryExecutor.start();
        this.responseWatchExecutor.start();
        this.longRunTasks.add(ThreadUtils.create(this::watchElementCheck));
        this.longRunTasks.add(ThreadUtils.create(this::keepAlive));
        this.longRunTasks.forEach(Thread::start);
        this.logger.debug("syncResponseHandler start.");
    }

    public void stop() {
        this.isShutdown = true;
        this.retryExecutor.stop();
        this.responseWatchExecutor.stop();
        ThreadUtils.shutdown(null, (long)3L);
        this.logger.debug("syncResponseHandler stop.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void invoke(EntityClassSyncRequest entityClassSyncRequest, StreamObserver<EntityClassSyncResponse> responseStreamObserver) {
        if (entityClassSyncRequest.getStatus() == RequestStatus.HEARTBEAT.ordinal()) {
            String uid = entityClassSyncRequest.getUid();
            if (uid.isEmpty()) return;
            this.confirmHeartBeat(uid, responseStreamObserver);
            return;
        } else if (entityClassSyncRequest.getStatus() == RequestStatus.REGISTER.ordinal()) {
            Integer currentVersion;
            WatchElement w = new WatchElement(entityClassSyncRequest.getAppId(), entityClassSyncRequest.getEnv(), entityClassSyncRequest.getVersion(), WatchElement.ElementStatus.Register);
            this.responseWatchExecutor.add(entityClassSyncRequest.getUid(), responseStreamObserver, w);
            if (entityClassSyncRequest.getForce()) {
                this.pull(entityClassSyncRequest.getUid(), entityClassSyncRequest.getForce(), w, RequestStatus.SYNC_OK);
                this.logger.debug("force pull uid [{}], appId [{}], env [{}]...", new Object[]{entityClassSyncRequest.getUid(), entityClassSyncRequest.getAppId(), entityClassSyncRequest.getEnv()});
            } else if (this.confirmRegister(entityClassSyncRequest.getAppId(), entityClassSyncRequest.getEnv(), entityClassSyncRequest.getVersion(), entityClassSyncRequest.getUid()) && (null == (currentVersion = this.responseWatchExecutor.version(entityClassSyncRequest.getAppId(), entityClassSyncRequest.getEnv())) || -1 == entityClassSyncRequest.getVersion() || entityClassSyncRequest.getVersion() != currentVersion.intValue())) {
                this.pull(entityClassSyncRequest.getUid(), entityClassSyncRequest.getForce(), w, RequestStatus.SYNC_OK);
                this.logger.debug("pull data success on SYNC_OK, uid [{}], appId [{}], env [{}], version [{}]", new Object[]{entityClassSyncRequest.getUid(), entityClassSyncRequest.getAppId(), entityClassSyncRequest.getEnv(), entityClassSyncRequest.getVersion()});
            }
            this.logger.debug("register uid [{}], appId [{}], env [{}], version [{}] success.", new Object[]{entityClassSyncRequest.getUid(), entityClassSyncRequest.getAppId(), entityClassSyncRequest.getEnv(), entityClassSyncRequest.getVersion()});
            return;
        } else if (entityClassSyncRequest.getStatus() == RequestStatus.SYNC_OK.ordinal()) {
            try {
                WatchElement w = new WatchElement(entityClassSyncRequest.getAppId(), entityClassSyncRequest.getEnv(), entityClassSyncRequest.getVersion(), WatchElement.ElementStatus.Confirmed);
                boolean ret = this.responseWatchExecutor.update(entityClassSyncRequest.getUid(), w);
                if (!ret) return;
                this.logger.info("sync data success, uid [{}], appId [{}], env [{}], version [{}] success.", new Object[]{entityClassSyncRequest.getUid(), entityClassSyncRequest.getAppId(), entityClassSyncRequest.getEnv(), entityClassSyncRequest.getVersion()});
                return;
            }
            finally {
                this.dataHandleFailedCounter.set(0);
                this.dataFormatErrorCounter.set(0);
            }
        } else if (entityClassSyncRequest.getStatus() == RequestStatus.SYNC_FAIL.ordinal()) {
            this.dataHandleFailedCounter.incrementAndGet();
            this.logger.warn("sync data handle failed, uid [{}], appId [{}], env [{}], version [{}] success.", new Object[]{entityClassSyncRequest.getUid(), entityClassSyncRequest.getAppId(), entityClassSyncRequest.getEnv(), entityClassSyncRequest.getVersion()});
            return;
        } else {
            if (entityClassSyncRequest.getStatus() != RequestStatus.DATA_ERROR.ordinal()) return;
            this.dataFormatErrorCounter.incrementAndGet();
            this.logger.warn("sync data format error, uid [{}], appId [{}], env [{}], version [{}] success.", new Object[]{entityClassSyncRequest.getUid(), entityClassSyncRequest.getAppId(), entityClassSyncRequest.getEnv(), entityClassSyncRequest.getVersion()});
        }
    }

    public boolean isShutDown() {
        return this.isShutdown;
    }

    @Override
    public void pull(String uid, boolean force, WatchElement watchElement, RequestStatus requestStatus) {
        this.taskExecutor.submit(() -> this.internalPull(uid, force, watchElement, requestStatus));
    }

    @Override
    public boolean push(AppUpdateEvent event) {
        if (this.responseWatchExecutor.addVersion(event.getAppId(), event.getEnv(), event.getVersion())) {
            List<ResponseWatcher> needList = null;
            try {
                needList = this.responseWatchExecutor.need(new WatchElement(event.getAppId(), event.getEnv(), event.getVersion(), WatchElement.ElementStatus.Notice));
            }
            catch (Exception e) {
                this.logger.warn("push event failed...event [{}-{}-{}], message [{}]", new Object[]{event.getAppId(), event.getEnv(), event.getVersion(), e.getMessage()});
                return false;
            }
            if (null != needList && !needList.isEmpty()) {
                for (ResponseWatcher r : needList) {
                    this.taskExecutor.submit(() -> {
                        try {
                            EntityClassSyncResponse response = this.generateResponse(r.uid(), event.getAppId(), event.getEnv(), event.getVersion(), RequestStatus.SYNC, event.getEntityClassSyncRspProto(), false);
                            this.responseByWatch(event.getAppId(), event.getEnv(), event.getVersion(), response, r, false);
                        }
                        catch (Exception e) {
                            this.logger.warn("push event failed..., uid [{}], event [{}], message [{}]", new Object[]{r.uid(), event, e.getMessage()});
                        }
                    });
                }
            } else {
                this.logger.warn("need list is empty, no watch on event [{}-{}-{}]", new Object[]{event.getAppId(), event.getEnv(), event.getVersion()});
            }
        } else {
            this.logger.warn("appId [{}], env [{}], push version [{}] is less than watcher version [{}], ignore...", new Object[]{event.getAppId(), event.getEnv(), event.getVersion(), this.responseWatchExecutor.version(event.getAppId(), event.getEnv())});
        }
        return true;
    }

    private boolean internalPull(String uid, boolean force, WatchElement watchElement, RequestStatus requestStatus) {
        ResponseWatcher watcher = this.responseWatchExecutor.watcher(uid);
        if (null != watcher && watcher.isActive()) {
            try {
                AppUpdateEvent appUpdateEvent = this.entityClassGenerator.pull(watchElement.getAppId(), watchElement.getEnv());
                if (force || this.isNeedEvent(watchElement.getVersion(), appUpdateEvent.getVersion(), requestStatus)) {
                    EntityClassSyncResponse response = this.generateResponse(uid, appUpdateEvent.getAppId(), appUpdateEvent.getEnv(), appUpdateEvent.getVersion(), RequestStatus.SYNC, appUpdateEvent.getEntityClassSyncRspProto(), force);
                    return this.responseByWatch(appUpdateEvent.getAppId(), appUpdateEvent.getEnv(), appUpdateEvent.getVersion(), response, watcher, force);
                }
                this.logger.info("current notice version [{}] is large than updateVersion [{}], event will be ignore...", (Object)watchElement.getVersion(), (Object)appUpdateEvent.getVersion());
                return true;
            }
            catch (Exception e) {
                if (e instanceof MetaSyncServerException && e.getMessage().equalsIgnoreCase(Code.APP_UPDATE_PULL_ERROR.name())) {
                    this.retryExecutor.offer((Object)new RetryExecutor.DelayTask(this.grpcParams.getDefaultDelayTaskDuration(), new RetryExecutor.Element(new WatchElement(watchElement.getAppId(), watchElement.getEnv(), watchElement.getVersion(), watchElement.getStatus()), watcher.uid())));
                }
                this.logger.warn(e.getMessage());
                return false;
            }
        }
        this.logger.warn("not exist watcher to handle data sync response, appId [{}], version [{}], uid [{}]...", new Object[]{watchElement.getAppId(), watchElement.getVersion(), uid});
        return false;
    }

    private boolean confirmRegister(String appId, String env, int version, String uid) {
        return this.confirmResponse(appId, env, version, uid, RequestStatus.REGISTER_OK);
    }

    private void confirmHeartBeat(String uid, StreamObserver<EntityClassSyncResponse> responseStreamObserver) {
        ResponseWatcher responseWatcher = this.responseWatchExecutor.watcher(uid);
        if (null != responseWatcher && responseWatcher.isActive()) {
            this.responseWatchExecutor.resetHeartBeat(uid);
        }
        responseStreamObserver.onNext((Object)EntityClassSyncResponse.newBuilder().setUid(uid).setStatus(RequestStatus.HEARTBEAT.ordinal()).build());
    }

    private boolean isNeedEvent(int expected, int actual, RequestStatus requestStatus) {
        switch (requestStatus) {
            case SYNC_OK: {
                return expected < actual;
            }
            case SYNC_FAIL: {
                return expected <= actual;
            }
        }
        return false;
    }

    private boolean confirmResponse(String appId, String env, int version, String uid, RequestStatus requestStatus) {
        ResponseWatcher watcher = this.responseWatchExecutor.watcher(uid);
        if (null != watcher) {
            EntityClassSyncResponse.Builder builder = EntityClassSyncResponse.newBuilder().setUid(uid).setStatus(requestStatus.ordinal());
            if (requestStatus.equals((Object)RequestStatus.REGISTER_OK)) {
                builder.setAppId(appId).setVersion(version).setEnv(env);
            }
            return this.responseByWatch(appId, env, version, builder.build(), watcher, true);
        }
        this.logger.warn("watch not exist to handle confirm : {} response, appId: {}, version : {}, uid :{}...", new Object[]{requestStatus.name(), appId, version, uid});
        return false;
    }

    private boolean responseByWatch(String appId, String env, int version, EntityClassSyncResponse response, ResponseWatcher watcher, boolean registerOrHeartBeat) {
        boolean ret = this.observerOnNext(response, watcher);
        if (ret && !registerOrHeartBeat) {
            this.logger.info("send app-pack ok, response [{}, {}, {}, {}]", new Object[]{"RSP APP_ID:" + response.getAppId(), "ENV:" + response.getEnv(), "VER:" + response.getVersion(), "UID:" + response.getUid()});
            this.retryExecutor.offer((Object)new RetryExecutor.DelayTask(this.grpcParams.getDefaultDelayTaskDuration(), new RetryExecutor.Element(new WatchElement(appId, env, version, WatchElement.ElementStatus.Notice), watcher.uid())));
        }
        return ret;
    }

    private boolean observerOnNext(EntityClassSyncResponse response, ResponseWatcher watcher) {
        if (null != watcher) {
            return watcher.runWithCheck(observer -> {
                try {
                    observer.onNext((Object)response);
                    return true;
                }
                catch (Exception e) {
                    this.logger.warn("response to observer[{}] failed.", (Object)watcher.uid());
                    TimeWaitUtils.wakeupAfter((long)1L, (TimeUnit)TimeUnit.MILLISECONDS);
                    this.responseWatchExecutor.release(watcher.uid());
                    return false;
                }
            });
        }
        this.logger.warn("current watch is not exists or has been removed...");
        return false;
    }

    private EntityClassSyncResponse generateResponse(String uid, String appId, String env, int version, RequestStatus requestStatus, EntityClassSyncRspProto result, boolean force) {
        return EntityClassSyncResponse.newBuilder().setMd5(MD5Utils.getMD5((byte[])result.toByteArray())).setUid(uid).setAppId(appId).setEnv(env).setVersion(version).setStatus(requestStatus.ordinal()).setEntityClassSyncRspProto(result).setForce(force).build();
    }

    private boolean watchElementCheck() {
        while (!this.isShutdown) {
            RetryExecutor.DelayTask task = (RetryExecutor.DelayTask)this.retryExecutor.take();
            if (null == task || null == task.element()) {
                if (this.isShutdown) continue;
                TimeWaitUtils.wakeupAfter((long)1L, (TimeUnit)TimeUnit.SECONDS);
                continue;
            }
            ResponseWatcher watcher = this.responseWatchExecutor.watcher(task.element().getUid());
            if (null == watcher) continue;
            WatchElement w = task.element().getElement();
            if (!watcher.isActive() || !watcher.onWatch(w)) continue;
            this.pull(task.element().getUid(), false, w, RequestStatus.SYNC_FAIL);
            this.logger.debug("delay task re-pull success, uid [{}], appId [{}], env [{}], version [{}] success.", new Object[]{watcher.uid(), w.getAppId(), w.getEnv(), w.getVersion()});
        }
        this.logger.info("delayTask has quited due to server shutdown...");
        return true;
    }

    private boolean keepAlive() {
        while (!this.isShutdown) {
            this.responseWatchExecutor.keepAliveCheck(this.grpcParams.getDefaultHeartbeatTimeout());
            TimeWaitUtils.wakeupAfter((long)this.grpcParams.getMonitorSleepDuration(), (TimeUnit)TimeUnit.MILLISECONDS);
        }
        this.logger.info("keepAlive check has quited due to server shutdown...");
        return true;
    }
}

