/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.meta.executor;

import com.xforceplus.ultraman.oqsengine.meta.common.dto.WatchElement;
import com.xforceplus.ultraman.oqsengine.meta.common.executor.IDelayTaskExecutor;
import java.util.Objects;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryExecutor
implements IDelayTaskExecutor<DelayTask> {
    final Logger logger = LoggerFactory.getLogger(RetryExecutor.class);
    private static final DelayQueue<DelayTask> delayTasks = new DelayQueue();
    private volatile boolean isActive = true;

    public DelayTask take() {
        if (this.isActive) {
            try {
                return (DelayTask)delayTasks.poll(1L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                this.logger.warn("retryExecutor is interrupted, may stop server...");
            }
        }
        return null;
    }

    public void offer(DelayTask task) {
        if (this.isActive) {
            try {
                if (!delayTasks.contains(task)) {
                    delayTasks.offer(task);
                }
            }
            catch (Exception e) {
                this.logger.warn("offer failed, message : {}", (Object)e.getMessage());
            }
        }
    }

    public void stop() {
        this.isActive = false;
    }

    public void start() {
        this.isActive = true;
    }

    public static class DelayTask
    implements Delayed {
        private final Element element;
        private final long start;
        private final long expireTime;

        public DelayTask(long delayInMillis, Element e) {
            this.element = e;
            this.start = System.currentTimeMillis();
            this.expireTime = delayInMillis;
        }

        public Element element() {
            return this.element;
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return unit.convert(this.start + this.expireTime - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
        }

        @Override
        public int compareTo(Delayed o) {
            return (int)(this.getDelay(TimeUnit.MILLISECONDS) - o.getDelay(TimeUnit.MILLISECONDS));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DelayTask)) {
                return false;
            }
            DelayTask delayTask = (DelayTask)o;
            return Objects.equals(this.element, delayTask.element);
        }

        public int hashCode() {
            return Objects.hash(this.element);
        }
    }

    public static class Element {
        private final WatchElement watch;
        private final String uid;
        private final String clientId;

        public Element(WatchElement w, String uid, String clientId) {
            this.uid = uid;
            this.watch = w;
            this.clientId = clientId;
        }

        public String getUid() {
            return this.uid;
        }

        public WatchElement getElement() {
            return this.watch;
        }

        public String getClientId() {
            return this.clientId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Element)) {
                return false;
            }
            Element element = (Element)o;
            return this.watch.logicEquals(element.watch) && Objects.equals(this.uid, element.uid) && Objects.equals(this.clientId, element.clientId);
        }

        public int hashCode() {
            return Objects.hash(this.watch, this.uid, this.clientId);
        }
    }
}

