/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.meta.handler;

import com.xforceplus.ultraman.oqsengine.meta.common.config.GRpcParams;
import com.xforceplus.ultraman.oqsengine.meta.common.constant.RequestStatus;
import com.xforceplus.ultraman.oqsengine.meta.common.dto.WatchElement;
import com.xforceplus.ultraman.oqsengine.meta.common.exception.Code;
import com.xforceplus.ultraman.oqsengine.meta.common.exception.MetaSyncServerException;
import com.xforceplus.ultraman.oqsengine.meta.common.executor.IDelayTaskExecutor;
import com.xforceplus.ultraman.oqsengine.meta.common.monitor.MetricsRecorder;
import com.xforceplus.ultraman.oqsengine.meta.common.monitor.dto.MetricsLog;
import com.xforceplus.ultraman.oqsengine.meta.common.monitor.dto.SyncCode;
import com.xforceplus.ultraman.oqsengine.meta.common.proto.sync.EntityClassSyncRequest;
import com.xforceplus.ultraman.oqsengine.meta.common.proto.sync.EntityClassSyncResponse;
import com.xforceplus.ultraman.oqsengine.meta.common.proto.sync.EntityClassSyncRspProto;
import com.xforceplus.ultraman.oqsengine.meta.common.utils.MD5Utils;
import com.xforceplus.ultraman.oqsengine.meta.common.utils.ThreadUtils;
import com.xforceplus.ultraman.oqsengine.meta.common.utils.TimeWaitUtils;
import com.xforceplus.ultraman.oqsengine.meta.dto.ResponseWatcher;
import com.xforceplus.ultraman.oqsengine.meta.dto.ServerSyncEvent;
import com.xforceplus.ultraman.oqsengine.meta.executor.IResponseWatchExecutor;
import com.xforceplus.ultraman.oqsengine.meta.executor.RetryExecutor;
import com.xforceplus.ultraman.oqsengine.meta.handler.IResponseHandler;
import com.xforceplus.ultraman.oqsengine.meta.provider.outter.EntityClassGenerator;
import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncResponseHandler
implements IResponseHandler {
    private final Logger logger = LoggerFactory.getLogger(SyncResponseHandler.class);
    @Resource
    private IResponseWatchExecutor responseWatchExecutor;
    @Resource
    private IDelayTaskExecutor<RetryExecutor.DelayTask> retryExecutor;
    @Resource
    private EntityClassGenerator entityClassGenerator;
    @Resource(name="grpcTaskExecutor")
    private ExecutorService taskExecutor;
    @Resource
    private GRpcParams grpcParams;
    @Resource
    private MetricsRecorder metricsRecorder;
    private final List<Thread> longRunTasks = new ArrayList<Thread>(2);
    private volatile boolean isShutdown = false;

    public void start() {
        this.isShutdown = false;
        this.retryExecutor.start();
        this.responseWatchExecutor.start();
        this.longRunTasks.add(ThreadUtils.create(this::watchElementCheck));
        this.longRunTasks.add(ThreadUtils.create(this::keepAlive));
        this.longRunTasks.forEach(Thread::start);
        this.logger.debug("syncResponseHandler start.");
    }

    public void stop() {
        this.isShutdown = true;
        this.retryExecutor.stop();
        this.responseWatchExecutor.stop();
        this.longRunTasks.forEach(runTask -> ThreadUtils.shutdown(null, (long)3L));
        this.longRunTasks.clear();
        this.logger.debug("syncResponseHandler stop.");
    }

    public void invoke(EntityClassSyncRequest entityClassSyncRequest, StreamObserver<EntityClassSyncResponse> responseStreamObserver) {
        this.logger.info("grpc-request in : clientId : {}\uff0c appId : {}, status : {}", new Object[]{entityClassSyncRequest.getClientId(), entityClassSyncRequest.getAppId(), RequestStatus.getInstance((int)entityClassSyncRequest.getStatus())});
        String uid = entityClassSyncRequest.getUid();
        if (!uid.isEmpty()) {
            this.confirmHeartBeat(uid, responseStreamObserver);
        }
        if (entityClassSyncRequest.getStatus() == RequestStatus.REGISTER.ordinal() || entityClassSyncRequest.getStatus() == RequestStatus.RESET.ordinal()) {
            Integer currentVersion;
            WatchElement w = new WatchElement(entityClassSyncRequest.getAppId(), entityClassSyncRequest.getEnv(), entityClassSyncRequest.getVersion(), WatchElement.ElementStatus.Register);
            boolean isForce = entityClassSyncRequest.getForce();
            if (entityClassSyncRequest.getStatus() == RequestStatus.RESET.ordinal()) {
                isForce = true;
            }
            this.responseWatchExecutor.add(entityClassSyncRequest.getClientId(), entityClassSyncRequest.getUid(), responseStreamObserver, w, isForce);
            if (entityClassSyncRequest.getForce() || entityClassSyncRequest.getStatus() == RequestStatus.RESET.ordinal()) {
                if (entityClassSyncRequest.getStatus() == RequestStatus.RESET.ordinal()) {
                    this.confirmRegister(entityClassSyncRequest.getAppId(), entityClassSyncRequest.getEnv(), entityClassSyncRequest.getVersion(), entityClassSyncRequest.getUid());
                }
                this.pull(entityClassSyncRequest.getClientId(), entityClassSyncRequest.getUid(), entityClassSyncRequest.getForce(), w, RequestStatus.SYNC_OK);
            } else if (this.confirmRegister(entityClassSyncRequest.getAppId(), entityClassSyncRequest.getEnv(), entityClassSyncRequest.getVersion(), entityClassSyncRequest.getUid()) && (null == (currentVersion = this.responseWatchExecutor.version(entityClassSyncRequest.getAppId(), entityClassSyncRequest.getEnv())) || -1 == entityClassSyncRequest.getVersion() || entityClassSyncRequest.getVersion() != currentVersion.intValue())) {
                this.pull(entityClassSyncRequest.getClientId(), entityClassSyncRequest.getUid(), entityClassSyncRequest.getForce(), w, RequestStatus.SYNC_OK);
            }
            this.logger.debug("register uid [{}], appId [{}], env [{}], version [{}] success.", new Object[]{entityClassSyncRequest.getUid(), entityClassSyncRequest.getAppId(), entityClassSyncRequest.getEnv(), entityClassSyncRequest.getVersion()});
        } else if (entityClassSyncRequest.getStatus() == RequestStatus.SYNC_OK.ordinal()) {
            WatchElement w = new WatchElement(entityClassSyncRequest.getAppId(), entityClassSyncRequest.getEnv(), entityClassSyncRequest.getVersion(), WatchElement.ElementStatus.Confirmed);
            boolean ret = this.responseWatchExecutor.update(entityClassSyncRequest.getUid(), w);
            if (ret) {
                this.metricsRecorder.info(entityClassSyncRequest.getAppId(), MetricsLog.linkKey((String[])new String[]{entityClassSyncRequest.getClientId(), SyncCode.SYNC_DATA_OK.name()}), String.format("sync data success, clientId : %s, env : %s, version : %d.", entityClassSyncRequest.getClientId(), entityClassSyncRequest.getEnv(), entityClassSyncRequest.getVersion()));
            }
        } else if (entityClassSyncRequest.getStatus() == RequestStatus.SYNC_FAIL.ordinal()) {
            this.metricsRecorder.error(entityClassSyncRequest.getAppId(), MetricsLog.linkKey((String[])new String[]{entityClassSyncRequest.getClientId(), SyncCode.SYNC_DATA_ERROR.name()}), String.format("sync data failed, clientId : %s, env : %s, version : %d.", entityClassSyncRequest.getClientId(), entityClassSyncRequest.getEnv(), entityClassSyncRequest.getVersion()));
        } else if (entityClassSyncRequest.getStatus() == RequestStatus.DATA_ERROR.ordinal()) {
            this.metricsRecorder.error(entityClassSyncRequest.getAppId(), MetricsLog.linkKey((String[])new String[]{entityClassSyncRequest.getClientId(), SyncCode.SYNC_DATA_ERROR.name()}), String.format("sync data format error, clientId : %s, env : %s, version : %d.", entityClassSyncRequest.getClientId(), entityClassSyncRequest.getEnv(), entityClassSyncRequest.getVersion()));
        }
    }

    public boolean isShutDown() {
        return this.isShutdown;
    }

    @Override
    public void pull(String clientId, String uid, boolean force, WatchElement watchElement, RequestStatus requestStatus) {
        this.taskExecutor.submit(() -> {
            try {
                this.internalPull(uid, force, watchElement, requestStatus);
            }
            catch (Exception e) {
                if (e instanceof MetaSyncServerException && e.getMessage().equalsIgnoreCase(Code.APP_UPDATE_PULL_ERROR.name())) {
                    this.retryExecutor.offer((Object)new RetryExecutor.DelayTask(this.grpcParams.getDefaultDelayTaskDuration(), new RetryExecutor.Element(new WatchElement(watchElement.getAppId(), watchElement.getEnv(), watchElement.getVersion(), watchElement.getStatus()), uid, clientId)));
                }
                this.metricsRecorder.info(watchElement.getAppId(), MetricsLog.linkKey((String[])new String[]{clientId, SyncCode.PULL_DATA_FAILED.name()}), String.format("pull data failed, clientId : %s, env : %s, version : %d, message : %s", clientId, watchElement.getEnv(), watchElement.getVersion(), e.getMessage()));
            }
        });
    }

    @Override
    public boolean push(ServerSyncEvent event) {
        if (this.responseWatchExecutor.addVersion(event.appId(), event.env(), event.version())) {
            List<ResponseWatcher> needList = null;
            try {
                needList = this.responseWatchExecutor.need(new WatchElement(event.appId(), event.env(), event.version(), WatchElement.ElementStatus.Notice));
            }
            catch (Exception e) {
                this.metricsRecorder.error(event.appId(), SyncCode.PUSH_DATA_CHECK_FAILED.name(), String.format("check needList failed, env : %s, version : %d, message : %s", event.env(), event.version(), e.getMessage()));
                return false;
            }
            if (null != needList && !needList.isEmpty()) {
                for (ResponseWatcher r : needList) {
                    this.taskExecutor.submit(() -> {
                        try {
                            EntityClassSyncResponse response = this.generateResponse(r.uid(), event.appId(), event.env(), event.version(), RequestStatus.SYNC, event.entityClassSyncRspProto(), false);
                            this.responseByWatch(event.appId(), event.env(), event.version(), response, r, false);
                        }
                        catch (Exception e) {
                            this.metricsRecorder.error(event.appId(), MetricsLog.linkKey((String[])new String[]{r.clientId(), SyncCode.SEND_PUSH_DATA_FAILED.name()}), String.format("send push data failed, env : %s, version : %d, message : %s", event.env(), event.version(), e.getMessage()));
                        }
                    });
                }
            } else {
                this.logger.warn("need list is empty, no watch on event [{}-{}-{}]", new Object[]{event.appId(), event.env(), event.version()});
            }
        } else {
            this.logger.warn("appId [{}], env [{}], push version [{}] is less than watcher version [{}], ignore...", new Object[]{event.appId(), event.env(), event.version(), this.responseWatchExecutor.version(event.appId(), event.env())});
        }
        return true;
    }

    private boolean internalPull(String uid, boolean force, WatchElement watchElement, RequestStatus requestStatus) {
        ResponseWatcher watcher = this.responseWatchExecutor.watcher(uid);
        if (null != watcher && watcher.isActive()) {
            ServerSyncEvent appUpdateEvent = this.entityClassGenerator.pull(watchElement.getAppId(), watchElement.getEnv());
            if (null == appUpdateEvent) {
                this.logger.warn("pull data fail, appUpdateEvent is null, app {}, env {}.", (Object)watchElement.getAppId(), (Object)watchElement.getEnv());
                return false;
            }
            if (this.isNeedEvent(watchElement, appUpdateEvent, requestStatus, force)) {
                EntityClassSyncResponse response = this.generateResponse(uid, appUpdateEvent.appId(), appUpdateEvent.env(), appUpdateEvent.version(), RequestStatus.SYNC, appUpdateEvent.entityClassSyncRspProto(), force);
                return this.responseByWatch(appUpdateEvent.appId(), appUpdateEvent.env(), appUpdateEvent.version(), response, watcher, force);
            }
            this.logger.info("current notice version [{}] is large than updateVersion [{}], event will be ignore...", (Object)watchElement.getVersion(), (Object)appUpdateEvent.version());
            return true;
        }
        this.logger.warn("not exist watcher to handle data sync response, appId [{}], version [{}], uid [{}]...", new Object[]{watchElement.getAppId(), watchElement.getVersion(), uid});
        return false;
    }

    private boolean confirmRegister(String appId, String env, int version, String uid) {
        return this.confirmResponse(appId, env, version, uid, RequestStatus.REGISTER_OK);
    }

    private void confirmHeartBeat(String uid, StreamObserver<EntityClassSyncResponse> responseStreamObserver) {
        ResponseWatcher responseWatcher = this.responseWatchExecutor.watcher(uid);
        if (null != responseWatcher && responseWatcher.isActive()) {
            this.responseWatchExecutor.resetHeartBeat(uid);
        }
        responseStreamObserver.onNext((Object)EntityClassSyncResponse.newBuilder().setUid(uid).setStatus(RequestStatus.HEARTBEAT.ordinal()).build());
    }

    private boolean isNeedEvent(WatchElement expected, ServerSyncEvent actual, RequestStatus requestStatus, boolean force) {
        if (!expected.getAppId().equals(actual.appId())) {
            this.logger.warn("pull data fail, expected appId {} not equals to event-returns {}", (Object)expected.getAppId(), (Object)actual.appId());
            return false;
        }
        if (!expected.getEnv().equals(actual.env())) {
            this.logger.warn("pull data fail, appId {}, expected env {} not equals to event-returns {}", new Object[]{expected.getAppId(), expected.getEnv(), actual.env()});
            return false;
        }
        if (!force) {
            switch (requestStatus) {
                case SYNC_OK: {
                    return expected.getVersion() < actual.version();
                }
                case SYNC_FAIL: {
                    return expected.getVersion() <= actual.version();
                }
            }
            return false;
        }
        return true;
    }

    private boolean confirmResponse(String appId, String env, int version, String uid, RequestStatus requestStatus) {
        ResponseWatcher watcher = this.responseWatchExecutor.watcher(uid);
        if (null != watcher) {
            EntityClassSyncResponse.Builder builder = EntityClassSyncResponse.newBuilder().setUid(uid).setStatus(requestStatus.ordinal());
            if (requestStatus.equals((Object)RequestStatus.REGISTER_OK)) {
                builder.setAppId(appId).setVersion(version).setEnv(env);
            }
            return this.responseByWatch(appId, env, version, builder.build(), watcher, true);
        }
        this.logger.warn("watch not exist to handle confirm : {} response, appId: {}, version : {}, uid :{}...", new Object[]{requestStatus.name(), appId, version, uid});
        return false;
    }

    private boolean responseByWatch(String appId, String env, int version, EntityClassSyncResponse response, ResponseWatcher watcher, boolean registerOrHeartBeat) {
        boolean ret = this.observerOnNext(response, watcher);
        if (ret && !registerOrHeartBeat) {
            this.logger.info("send app-pack ok, response [{}, {}, {}, {}]", new Object[]{"RSP APP_ID:" + response.getAppId(), "ENV:" + response.getEnv(), "VER:" + response.getVersion(), "UID:" + response.getUid()});
            this.retryExecutor.offer((Object)new RetryExecutor.DelayTask(this.grpcParams.getDefaultDelayTaskDuration(), new RetryExecutor.Element(new WatchElement(appId, env, version, WatchElement.ElementStatus.Notice), watcher.uid(), watcher.clientId())));
        }
        return ret;
    }

    private boolean observerOnNext(EntityClassSyncResponse response, ResponseWatcher watcher) {
        if (null != watcher) {
            return watcher.runWithCheck(observer -> {
                try {
                    observer.onNext((Object)response);
                    return true;
                }
                catch (Exception e) {
                    this.logger.warn("response to observer[{}] failed.", (Object)watcher.uid());
                    TimeWaitUtils.wakeupAfter((long)1L, (TimeUnit)TimeUnit.MILLISECONDS);
                    this.responseWatchExecutor.release(watcher.uid());
                    return false;
                }
            });
        }
        this.logger.warn("current watch is not exists or has been removed...");
        return false;
    }

    private EntityClassSyncResponse generateResponse(String uid, String appId, String env, int version, RequestStatus requestStatus, EntityClassSyncRspProto result, boolean force) {
        return EntityClassSyncResponse.newBuilder().setMd5(MD5Utils.getMD5((byte[])result.toByteArray())).setUid(uid).setAppId(appId).setEnv(env).setVersion(version).setStatus(requestStatus.ordinal()).setEntityClassSyncRspProto(result).setForce(force).build();
    }

    private boolean watchElementCheck() {
        while (!this.isShutdown) {
            RetryExecutor.DelayTask task = (RetryExecutor.DelayTask)this.retryExecutor.take();
            if (null == task || null == task.element()) {
                if (this.isShutdown) continue;
                TimeWaitUtils.wakeupAfter((long)1L, (TimeUnit)TimeUnit.SECONDS);
                continue;
            }
            ResponseWatcher watcher = this.responseWatchExecutor.watcher(task.element().getUid());
            if (null == watcher) continue;
            WatchElement w = task.element().getElement();
            if (!watcher.isActive() || !watcher.onWatch(w)) continue;
            this.pull(null, task.element().getUid(), false, w, RequestStatus.SYNC_FAIL);
            this.logger.debug("delay task re-pull success, uid [{}], appId [{}], env [{}], version [{}] success.", new Object[]{watcher.uid(), w.getAppId(), w.getEnv(), w.getVersion()});
        }
        this.logger.info("delayTask has quited due to server shutdown...");
        return true;
    }

    private boolean keepAlive() {
        while (!this.isShutdown) {
            this.responseWatchExecutor.keepAliveCheck(this.grpcParams.getDefaultHeartbeatTimeout());
            TimeWaitUtils.wakeupAfter((long)this.grpcParams.getMonitorSleepDuration(), (TimeUnit)TimeUnit.MILLISECONDS);
        }
        this.logger.info("keepAlive check has quited due to server shutdown...");
        return true;
    }
}

