/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.meta.config;

import com.xforceplus.ultraman.oqsengine.meta.common.config.GRpcParams;
import com.xforceplus.ultraman.oqsengine.meta.common.monitor.CachedMetricsRecorder;
import com.xforceplus.ultraman.oqsengine.meta.common.monitor.MetricsRecorder;
import com.xforceplus.ultraman.oqsengine.meta.common.utils.ExecutorHelper;
import com.xforceplus.ultraman.oqsengine.meta.shutdown.ShutDownExecutor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnExpression(value="'${meta.grpc.type}'.equals('client') || '${meta.grpc.type}'.equals('server')")
public class CommonConfiguration {
    @Bean
    public GRpcParams grpcParamsConfig(@Value(value="${meta.grpc.seconds.heartbeatTimeout:30}") long heartbeatTimeoutSec, @Value(value="${meta.grpc.seconds.delaytaskTimeout:30}") long delayTaskDurationSec, @Value(value="${meta.grpc.seconds.monitorDuration:1}") long sleepMonitorSec, @Value(value="${meta.grpc.seconds.reconnectDuration:5}") long sleepReconnectSec, @Value(value="${meta.grpc.seconds.keepAliveDuration:5}") long keepAliveSendDuration) {
        GRpcParams grpcParamsConfig = new GRpcParams();
        grpcParamsConfig.setDefaultHeartbeatTimeout(TimeUnit.SECONDS.toMillis(heartbeatTimeoutSec));
        grpcParamsConfig.setDefaultDelayTaskDuration(TimeUnit.SECONDS.toMillis(delayTaskDurationSec));
        grpcParamsConfig.setMonitorSleepDuration(TimeUnit.SECONDS.toMillis(sleepMonitorSec));
        grpcParamsConfig.setReconnectDuration(TimeUnit.SECONDS.toMillis(sleepReconnectSec));
        grpcParamsConfig.setKeepAliveSendDuration(TimeUnit.SECONDS.toMillis(keepAliveSendDuration));
        return grpcParamsConfig;
    }

    @Bean(value={"grpcTaskExecutor"})
    public ExecutorService metaSyncThreadPool(@Value(value="${threadPool.call.grpc.worker:0}") int worker, @Value(value="${threadPool.call.grpc.queue:500}") int queue) {
        int useWorker = worker;
        int useQueue = queue;
        if (useWorker == 0) {
            useWorker = Runtime.getRuntime().availableProcessors() + 1;
        }
        if (useQueue < 500) {
            useQueue = 500;
        }
        return ExecutorHelper.buildThreadPool((int)useWorker, (int)useQueue, (String)"meta-sync-call", (boolean)false);
    }

    @Bean
    public ShutDownExecutor shutDownExecutor() {
        return new ShutDownExecutor();
    }

    @Bean
    public MetricsRecorder cachedMetricsRecorder() {
        return new CachedMetricsRecorder();
    }
}

