/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.meta.shutdown;

import com.xforceplus.ultraman.oqsengine.meta.common.utils.ExecutorHelper;
import com.xforceplus.ultraman.oqsengine.meta.connect.GRpcServer;
import com.xforceplus.ultraman.oqsengine.meta.shutdown.IShutDown;
import java.util.concurrent.ExecutorService;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerShutDown
implements IShutDown {
    private final Logger logger = LoggerFactory.getLogger(ServerShutDown.class);
    @Resource
    GRpcServer grpcServer;
    @Resource(name="grpcServerExecutor")
    private ExecutorService grpcServerExecutor;
    @Resource(name="grpcTaskExecutor")
    private ExecutorService grpcTaskExecutor;

    @Override
    public void shutdown() {
        this.logger.info("meta sync server tear down...");
        this.grpcServer.stop();
        this.logger.info("Start closing the gRpc server thread...");
        ExecutorHelper.shutdownAndAwaitTermination((ExecutorService)this.grpcServerExecutor, (long)3600L);
        this.logger.info("Succeed closing the gRpc server worker thread...ok!");
        this.logger.info("Start closing the gRpc worker thread...");
        ExecutorHelper.shutdownAndAwaitTermination((ExecutorService)this.grpcTaskExecutor, (long)3600L);
        this.logger.info("Succeed closing the gRpc worker thread...ok!");
    }
}

