/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.metadata;

import com.xforceplus.ultraman.oqsengine.metadata.MetaManager;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public class MockMetaManager
implements MetaManager {
    private Map<String, IEntityClass> entityClassPool = new ConcurrentHashMap<String, IEntityClass>();

    public void addEntityClass(IEntityClass entityClass) {
        entityClass.family().stream().forEach(e -> this.entityClassPool.put(this.buildKey(e.id(), e.version()), (IEntityClass)e));
    }

    @Override
    public Optional<IEntityClass> load(long id) {
        return Optional.ofNullable(this.entityClassPool.entrySet().stream().filter(e -> this.parseIdFromKey((String)e.getKey()) == id).max((e0, e1) -> {
            if (((IEntityClass)e0.getValue()).version() < ((IEntityClass)e1.getValue()).version()) {
                return -1;
            }
            if (((IEntityClass)e0.getValue()).version() > ((IEntityClass)e1.getValue()).version()) {
                return 1;
            }
            return 0;
        }).get().getValue());
    }

    @Override
    public Optional<IEntityClass> loadHistory(long id, int version) {
        return Optional.ofNullable(this.entityClassPool.get(this.buildKey(id, version)));
    }

    @Override
    public int need(String appId, String env) {
        return 0;
    }

    @Override
    public void invalidateLocal() {
    }

    private String buildKey(long id, int version) {
        return String.format("%d-%d", id, version);
    }

    private long parseIdFromKey(String key) {
        String[] values = key.split("-");
        return Long.parseLong(values[0]);
    }
}

