/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.metadata;

import com.xforceplus.ultraman.oqsengine.meta.common.dto.WatchElement;
import com.xforceplus.ultraman.oqsengine.meta.common.pojo.EntityClassStorage;
import com.xforceplus.ultraman.oqsengine.meta.common.pojo.RelationStorage;
import com.xforceplus.ultraman.oqsengine.meta.handler.IRequestHandler;
import com.xforceplus.ultraman.oqsengine.metadata.MetaManager;
import com.xforceplus.ultraman.oqsengine.metadata.cache.CacheExecutor;
import com.xforceplus.ultraman.oqsengine.metadata.dto.HealthCheckEntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.FieldConfig;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.EntityField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.oqs.OqsEntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.oqs.OqsRelation;
import io.micrometer.core.annotation.Timed;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageMetaManager
implements MetaManager {
    final Logger logger = LoggerFactory.getLogger(StorageMetaManager.class);
    @Resource
    private CacheExecutor cacheExecutor;
    @Resource
    private IRequestHandler requestHandler;
    @Resource(name="taskThreadPool")
    private ExecutorService asyncDispatcher;

    private <T> CompletableFuture<T> async(Supplier<T> supplier) {
        return CompletableFuture.supplyAsync(supplier, this.asyncDispatcher);
    }

    @Override
    @Timed(value="oqs.process.delay.latency", extraTags={"initiator", "meta", "action", "load"})
    public Optional<IEntityClass> load(long id) {
        try {
            if (id == 0L) {
                return Optional.of(HealthCheckEntityClass.getInstance());
            }
            Map<Long, EntityClassStorage> entityClassStorageMaps = this.cacheExecutor.read(id);
            return Optional.of(this.toEntityClass(id, entityClassStorageMaps));
        }
        catch (Exception e) {
            this.logger.warn("load entityClass [{}] error.message is [{}]", (Object)id, (Object)e.toString());
            return Optional.empty();
        }
    }

    @Override
    public Optional<IEntityClass> loadHistory(long id, int version) {
        return Optional.empty();
    }

    @Override
    @Timed(value="oqs.process.delay.latency", extraTags={"initiator", "meta", "action", "need"})
    public int need(String appId, String env) {
        this.cacheExecutor.appEnvSet(appId, env);
        if (!this.cacheExecutor.appEnvGet(appId).equals(env)) {
            throw new RuntimeException("appId has been init with another Id, need failed...");
        }
        int version = this.cacheExecutor.version(appId);
        this.requestHandler.register(new WatchElement(appId, env, version, WatchElement.ElementStatus.Register));
        if (version < 0) {
            CompletableFuture<Integer> future = this.async(() -> {
                block3: {
                    int ver;
                    while ((ver = this.cacheExecutor.version(appId)) < 0) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException e) {
                            break block3;
                        }
                    }
                    return ver;
                }
                return -1;
            });
            try {
                version = future.get(60000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                e.printStackTrace();
                throw new RuntimeException(e.getMessage());
            }
            if (version == -1) {
                throw new RuntimeException(String.format("get version of appId [%s] failed, reach max wait time", appId));
            }
        }
        return version;
    }

    @Override
    public void invalidateLocal() {
        this.cacheExecutor.invalidateLocal();
    }

    private IEntityClass toEntityClass(long id, Map<Long, EntityClassStorage> entityClassStorageMaps) throws SQLException {
        EntityClassStorage entityClassStorage = entityClassStorageMaps.get(id);
        if (null == entityClassStorage) {
            throw new SQLException(String.format("entity class [%d] not found.", id));
        }
        ArrayList entityFields = new ArrayList();
        if (null != entityClassStorage.getFields()) {
            entityClassStorage.getFields().forEach(e -> {
                IEntityField entityField = this.cloneEntityField((IEntityField)e);
                if (null != entityField) {
                    entityFields.add(entityField);
                }
            });
        }
        OqsEntityClass.Builder builder = OqsEntityClass.Builder.anEntityClass().withId(entityClassStorage.getId()).withCode(entityClassStorage.getCode()).withName(entityClassStorage.getName()).withLevel(entityClassStorage.getLevel()).withVersion(entityClassStorage.getVersion()).withRelations(this.toQqsRelation(entityClassStorage.getRelations())).withFields(entityFields);
        if (null != entityClassStorage.getFatherId() && entityClassStorage.getFatherId() >= 1L) {
            builder.withFather(this.toEntityClass(entityClassStorage.getFatherId(), entityClassStorageMaps));
        }
        return builder.build();
    }

    private List<OqsRelation> toQqsRelation(List<RelationStorage> relationStorageList) {
        ArrayList<OqsRelation> oqsRelations = new ArrayList<OqsRelation>();
        if (null != relationStorageList) {
            relationStorageList.forEach(r -> {
                OqsRelation.Builder builder = OqsRelation.Builder.anOqsRelation().withId(r.getId()).withCode(r.getCode()).withLeftEntityClassId(r.getLeftEntityClassId()).withLeftEntityClassCode(r.getLeftEntityClassCode()).withRelationType(OqsRelation.RelationType.getInstance((int)r.getRelationType())).withIdentity(r.isIdentity()).withStrong(r.isStrong()).withRightEntityClassId(r.getRightEntityClassId()).withRightEntityClassLoader(this::load).withEntityField(this.cloneEntityField((IEntityField)r.getEntityField())).withBelongToOwner(r.isBelongToOwner());
                oqsRelations.add(builder.build());
            });
        }
        return oqsRelations;
    }

    private IEntityField cloneEntityField(IEntityField entityField) {
        if (null != entityField) {
            EntityField.Builder builder = EntityField.Builder.anEntityField().withName(entityField.name()).withCnName(entityField.cnName()).withFieldType(entityField.type()).withDictId(entityField.dictId()).withId(entityField.id()).withDefaultValue(entityField.defaultValue());
            if (null != entityField.config()) {
                FieldConfig config = entityField.config();
                builder.withConfig(FieldConfig.Builder.anFieldConfig().withDelimiter(config.getDelimiter()).withDisplayType(config.getDisplayType()).withFieldSense(config.getFieldSense()).withFuzzyType(config.getFuzzyType()).withIdentifie(config.isIdentifie()).withMax(config.getMax()).withMin(config.getMin()).withPrecision(config.getPrecision()).withRequired(config.isRequired()).withSearchable(config.isSearchable()).withSplittable(config.isSplittable()).withUniqueName(config.getUniqueName()).withValidateRegexString(config.getValidateRegexString()).withWildcardMaxWidth(config.getWildcardMaxWidth()).withWildcardMinWidth(config.getWildcardMinWidth()).build());
            }
            return builder.build();
        }
        return null;
    }
}

