/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.metadata.cache;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.xforceplus.ultraman.oqsengine.meta.common.exception.MetaSyncClientException;
import com.xforceplus.ultraman.oqsengine.meta.common.pojo.EntityClassStorage;
import com.xforceplus.ultraman.oqsengine.metadata.cache.CacheExecutor;
import com.xforceplus.ultraman.oqsengine.metadata.cache.RedisLuaScript;
import com.xforceplus.ultraman.oqsengine.metadata.utils.CacheUtils;
import com.xforceplus.ultraman.oqsengine.metadata.utils.EntityClassStorageConvert;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import io.lettuce.core.RedisClient;
import io.lettuce.core.ScriptOutputType;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.api.sync.RedisCommands;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCacheExecutor
implements CacheExecutor {
    final Logger logger = LoggerFactory.getLogger(DefaultCacheExecutor.class);
    @Resource
    private RedisClient redisClient;
    @Resource
    private ObjectMapper objectMapper;
    private Cache<String, EntityClassStorage> entityClassStorageCache;
    private StatefulRedisConnection<String, String> syncConnect;
    private RedisCommands<String, String> syncCommands;
    private int maxCacheSize = 1024;
    private int prepareExpire = 60;
    private int cacheExpire = 31104000;
    private String prepareVersionScriptSha;
    private String versionResetScriptSha;
    private String versionGetByEntityScriptSha;
    private String entityClassStorageScriptSha;
    private String entityClassStorageListScriptSha;
    private String appEnvKeys;
    private String appVersionKeys;
    private String appPrepareKeyPrefix;
    private String appEntityMappingKey;
    private String appEntityCollectionsKey;
    private String entityStorageKeys;

    public DefaultCacheExecutor() {
        this(0, 0, 0, "com.xforceplus.ultraman.oqsengine.metadata.app.env", "com.xforceplus.ultraman.oqsengine.metadata.versions", "com.xforceplus.ultraman.oqsengine.metadata.prepare", "com.xforceplus.ultraman.oqsengine.metadata.entity", "com.xforceplus.ultraman.oqsengine.metadata.entity.app.rel", "com.xforceplus.ultraman.oqsengine.metadata.app.version.entityIds");
    }

    public DefaultCacheExecutor(int maxCacheSize, int prepareExpireSeconds, int cacheExpireSeconds) {
        this(maxCacheSize, prepareExpireSeconds, cacheExpireSeconds, "com.xforceplus.ultraman.oqsengine.metadata.app.env", "com.xforceplus.ultraman.oqsengine.metadata.versions", "com.xforceplus.ultraman.oqsengine.metadata.prepare", "com.xforceplus.ultraman.oqsengine.metadata.entity", "com.xforceplus.ultraman.oqsengine.metadata.entity.app.rel", "com.xforceplus.ultraman.oqsengine.metadata.app.version.entityIds");
    }

    public DefaultCacheExecutor(int maxCacheSize, int prepareExpireSeconds, int cacheExpireSeconds, String appEnvKeys, String appVersionKeys, String appPrepareKeyPrefix, String entityStorageKeys, String appEntityMappingKey, String appEntityCollectionsKey) {
        if (maxCacheSize > 0) {
            this.maxCacheSize = maxCacheSize;
        }
        if (prepareExpireSeconds > 0) {
            this.prepareExpire = prepareExpireSeconds;
        }
        if (cacheExpireSeconds > 0) {
            this.cacheExpire = cacheExpireSeconds;
        }
        this.appEnvKeys = appEnvKeys;
        if (this.appEnvKeys == null || this.appEnvKeys.isEmpty()) {
            throw new IllegalArgumentException("The metadataAppEnv keys is invalid.");
        }
        this.appVersionKeys = appVersionKeys;
        if (this.appVersionKeys == null || this.appVersionKeys.isEmpty()) {
            throw new IllegalArgumentException("The metadataVersion keys is invalid.");
        }
        this.appPrepareKeyPrefix = appPrepareKeyPrefix;
        if (this.appPrepareKeyPrefix == null || this.appPrepareKeyPrefix.isEmpty()) {
            throw new IllegalArgumentException("The metadataPrepare key is invalid.");
        }
        this.entityStorageKeys = entityStorageKeys;
        if (this.entityStorageKeys == null || this.entityStorageKeys.isEmpty()) {
            throw new IllegalArgumentException("The metadataAppEntity key is invalid.");
        }
        this.appEntityMappingKey = appEntityMappingKey;
        if (this.appEntityMappingKey == null || this.appEntityMappingKey.isEmpty()) {
            throw new IllegalArgumentException("The metadataAppRel key is invalid.");
        }
        this.appEntityCollectionsKey = appEntityCollectionsKey;
        if (this.appEntityCollectionsKey == null || this.appEntityCollectionsKey.isEmpty()) {
            throw new IllegalArgumentException("The appEntityCollections key is invalid.");
        }
        this.entityClassStorageCache = this.initCache();
    }

    public void setMaxCacheSize(int maxCacheSize) {
        this.maxCacheSize = maxCacheSize;
    }

    public void setCacheExpire(int cacheExpire) {
        this.cacheExpire = cacheExpire;
    }

    public void setPrepareExpire(int prepareExpire) {
        this.prepareExpire = prepareExpire;
    }

    private <V> Cache<String, V> initCache() {
        return CacheBuilder.newBuilder().maximumSize((long)this.maxCacheSize).expireAfterAccess((long)this.cacheExpire, TimeUnit.SECONDS).build();
    }

    @PostConstruct
    public void init() {
        if (this.redisClient == null) {
            throw new IllegalStateException("Invalid redisClient.");
        }
        this.syncConnect = this.redisClient.connect();
        this.syncCommands = this.syncConnect.sync();
        this.syncCommands.clientSetname((Object)"oqs.sync.metadata");
        this.prepareVersionScriptSha = this.syncCommands.scriptLoad(RedisLuaScript.PREPARE_VERSION_SCRIPT);
        this.versionGetByEntityScriptSha = this.syncCommands.scriptLoad(RedisLuaScript.ACTIVE_VERSION);
        this.versionResetScriptSha = this.syncCommands.scriptLoad(RedisLuaScript.REST_VERSION);
        this.entityClassStorageScriptSha = this.syncCommands.scriptLoad(RedisLuaScript.ENTITY_CLASS_STORAGE_INFO);
        this.entityClassStorageListScriptSha = this.syncCommands.scriptLoad(RedisLuaScript.ENTITY_CLASS_STORAGE_INFO_LIST);
    }

    @PreDestroy
    public void destroy() {
        this.syncConnect.close();
    }

    @Override
    public boolean save(String appId, int version, List<EntityClassStorage> storageList) {
        for (EntityClassStorage storage : storageList) {
            String key = this.entityStorageKeys + "." + version + "." + storage.getId();
            this.syncCommands.hset((Object)key, (Object)"id", (Object)Long.toString(storage.getId()));
            this.syncCommands.hset((Object)key, (Object)"code", (Object)storage.getCode());
            this.syncCommands.hset((Object)key, (Object)"name", (Object)storage.getName());
            this.syncCommands.hset((Object)key, (Object)"level", (Object)Integer.toString(storage.getLevel()));
            this.syncCommands.hset((Object)key, (Object)"version", (Object)Integer.toString(storage.getVersion()));
            if (null != storage.getFatherId()) {
                this.syncCommands.hset((Object)key, (Object)"father", (Object)Long.toString(storage.getFatherId()));
                if (null != storage.getAncestors() && storage.getAncestors().size() > 0) {
                    try {
                        String ancestorStr = this.objectMapper.writeValueAsString((Object)storage.getAncestors());
                        this.syncCommands.hset((Object)key, (Object)"ancestors", (Object)ancestorStr);
                    }
                    catch (JsonProcessingException e) {
                        throw new MetaSyncClientException("parse ancestors failed.", false);
                    }
                }
            }
            if (null != storage.getRelations() && storage.getRelations().size() > 0) {
                try {
                    String relationStr = this.objectMapper.writeValueAsString((Object)storage.getRelations());
                    this.syncCommands.hset((Object)key, (Object)"relations", (Object)relationStr);
                }
                catch (JsonProcessingException e) {
                    throw new MetaSyncClientException("parse children failed.", false);
                }
            }
            if (null == storage.getFields()) continue;
            for (IEntityField entityField : storage.getFields()) {
                try {
                    String entityFieldStr = this.objectMapper.writeValueAsString((Object)entityField);
                    this.syncCommands.hset((Object)key, (Object)("fields." + entityField.id()), (Object)entityFieldStr);
                }
                catch (JsonProcessingException e) {
                    throw new MetaSyncClientException("parse entityField failed.", false);
                }
            }
        }
        return this.resetVersion(appId, version, storageList.stream().map(EntityClassStorage::getId).collect(Collectors.toList()));
    }

    @Override
    public Map<Long, EntityClassStorage> read(long entityClassId) throws JsonProcessingException {
        int version = this.version(entityClassId);
        if (-1 == version) {
            throw new RuntimeException(String.format("invalid entityClassId : [%s], no version pair", entityClassId));
        }
        EntityClassStorage entityClassStorage = this.getFromLocal(entityClassId, version);
        Map<Object, Object> entityClassStorageMap = null;
        if (null == entityClassStorage) {
            entityClassStorageMap = this.getFromRemote(entityClassId, version);
            entityClassStorageMap.forEach((k, v) -> this.addToLocal(CacheUtils.generateEntityCacheKey(k, version), (EntityClassStorage)v));
        } else {
            entityClassStorageMap = new HashMap();
            entityClassStorageMap.put(entityClassStorage.getId(), entityClassStorage);
            ArrayList ids = new ArrayList();
            if (null != entityClassStorage.getAncestors()) {
                ids.addAll(entityClassStorage.getAncestors());
            }
            for (Long r : ids) {
                EntityClassStorage e = this.getFromLocal(r, version);
                if (null == e) {
                    e = this.getOneFromRemote(r, version);
                    this.addToLocal(CacheUtils.generateEntityCacheKey(r, version), e);
                }
                entityClassStorageMap.put(r, e);
            }
        }
        return entityClassStorageMap;
    }

    @Override
    public Map<Long, EntityClassStorage> multiplyRead(List<Long> ids, int version) throws JsonProcessingException {
        HashMap<Long, EntityClassStorage> entityClassStorageMap = new HashMap<Long, EntityClassStorage>();
        if (null != ids && ids.size() > 0) {
            ArrayList<Long> remoteFilters = new ArrayList<Long>();
            ids.forEach(id -> {
                EntityClassStorage entityClassStorage = this.getFromLocal((long)id, version);
                if (null == entityClassStorage) {
                    remoteFilters.add((Long)id);
                } else {
                    entityClassStorageMap.put((Long)id, entityClassStorage);
                }
            });
            this.remoteMultiplyLoading(remoteFilters, version, entityClassStorageMap);
        }
        return entityClassStorageMap;
    }

    @Override
    public int version(String appId) {
        String versionStr = (String)this.syncCommands.hget((Object)this.appVersionKeys, (Object)appId);
        if (null != versionStr) {
            return Integer.parseInt(versionStr);
        }
        return -1;
    }

    @Override
    public int version(Long entityClassId) {
        if (null == entityClassId || entityClassId <= 0L) {
            return -1;
        }
        Object[] keys = new String[]{this.appEntityMappingKey, this.appVersionKeys};
        String v = (String)this.syncCommands.evalsha(this.versionGetByEntityScriptSha, ScriptOutputType.VALUE, keys, (Object[])new String[]{Long.toString(entityClassId)});
        return null != v ? Integer.parseInt(v) : -1;
    }

    @Override
    public boolean resetVersion(String appId, int version, List<Long> ids) {
        boolean ret;
        if (null == appId || appId.isEmpty()) {
            return false;
        }
        if (version < 0) {
            return false;
        }
        Object[] keys = new String[]{this.appEntityMappingKey, this.appVersionKeys};
        Object[] values = null;
        if (null != ids && ids.size() > 0) {
            values = new String[ids.size() + 2];
            int j = 2;
            for (Long id : ids) {
                values[j] = Long.toString(id);
                ++j;
            }
        } else {
            values = new String[]{appId, Integer.toString(version)};
        }
        if (ret = ((Boolean)this.syncCommands.evalsha(this.versionResetScriptSha, ScriptOutputType.BOOLEAN, keys, values)).booleanValue()) {
            try {
                String fieldName = String.format("%s.%s", appId, version);
                this.syncCommands.hset((Object)this.appEntityCollectionsKey, (Object)fieldName, (Object)this.objectMapper.writeValueAsString(ids));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ret;
    }

    @Override
    public boolean prepare(String appId, int version) {
        if (null == appId || appId.isEmpty()) {
            this.logger.warn("prepare appId is empty.");
            return false;
        }
        if (version < 0) {
            this.logger.warn("prepare [{}] failed, version [{}] is less than 0", (Object)appId, (Object)version);
            return false;
        }
        Object[] keys = new String[]{this.appVersionKeys, this.appPrepareKeyPrefix};
        try {
            return (Boolean)this.syncCommands.evalsha(this.prepareVersionScriptSha, ScriptOutputType.BOOLEAN, keys, (Object[])new String[]{Integer.toString(version), appId, Integer.toString(this.prepareExpire)});
        }
        catch (Exception e) {
            this.logger.warn("do prepare [{}]-[{}] failed, message [{}]", new Object[]{appId, version, e.toString()});
            throw e;
        }
    }

    @Override
    public boolean endPrepare(String appId) {
        if (null == appId || appId.isEmpty()) {
            return false;
        }
        try {
            return this.syncCommands.del((Object[])new String[]{String.format("%s.%s", this.appPrepareKeyPrefix, appId)}) > 0L;
        }
        catch (Exception e) {
            this.logger.warn("end prepare [{}] failed, message [{}]", (Object)appId, (Object)e.toString());
            return false;
        }
    }

    @Override
    public String appEnvGet(String appId) {
        return (String)this.syncCommands.hget((Object)this.appEnvKeys, (Object)appId);
    }

    @Override
    public boolean appEnvSet(String appId, String env) {
        return this.syncCommands.hsetnx((Object)this.appEnvKeys, (Object)appId, (Object)env);
    }

    @Override
    public boolean appEnvRemove(String appId) {
        return this.syncCommands.hdel((Object)this.appEnvKeys, (Object[])new String[]{appId}) == 1L;
    }

    @Override
    public boolean clean(String appId, int version, boolean force) {
        int activeVersion;
        if (!force && version >= (activeVersion = this.version(appId))) {
            return false;
        }
        String fieldName = String.format("%s.%s", appId, version);
        String v = (String)this.syncCommands.hget((Object)this.appEntityCollectionsKey, (Object)fieldName);
        if (null != v && !v.isEmpty()) {
            try {
                List ids = (List)this.objectMapper.readValue(v, this.objectMapper.getTypeFactory().constructParametricType(List.class, new Class[]{Long.class}));
                for (Long id : ids) {
                    this.doClean(id, version);
                }
                this.syncCommands.hdel((Object)this.appEntityCollectionsKey, (Object[])new String[]{fieldName});
            }
            catch (Exception e) {
                this.logger.warn("{}", (Object)e.toString());
            }
        }
        return true;
    }

    @Override
    public void invalidateLocal() {
        this.entityClassStorageCache.invalidateAll();
    }

    private boolean doClean(Long entityId, int version) {
        if (null == entityId) {
            return false;
        }
        if (version < 0) {
            return false;
        }
        this.invalidateFromLocal(entityId, version);
        boolean isDelete = this.invalidateFromRemote(entityId, version);
        if (!isDelete) {
            this.logger.warn("delete remote failed, entityId:[{}], version:[{}]", (Object)entityId, (Object)version);
        }
        return true;
    }

    private boolean invalidateFromRemote(Long entityId, int version) {
        String keys = String.format("%s.%s.%s", this.entityStorageKeys, Integer.toString(version), Long.toString(entityId));
        try {
            List entityClassKeys = this.syncCommands.hkeys((Object)keys);
            if (null != entityClassKeys && entityClassKeys.size() > 0) {
                return this.syncCommands.hdel((Object)keys, (Object[])entityClassKeys.toArray(new String[entityClassKeys.size()])) == (long)entityClassKeys.size();
            }
            return true;
        }
        catch (Exception e) {
            this.logger.warn("delete remote failed, entityId:[{}], version:[{}], message:[{}]", new Object[]{entityId, version, e.getMessage()});
            return false;
        }
    }

    private Map<Long, EntityClassStorage> getFromRemote(long entityClassId, int version) {
        try {
            HashMap<Long, EntityClassStorage> entityClassStorageMap = new HashMap<Long, EntityClassStorage>();
            EntityClassStorage entityClassStorage = this.getOneFromRemote(entityClassId, version);
            entityClassStorageMap.put(entityClassStorage.getId(), entityClassStorage);
            if (entityClassStorage.getAncestors().size() > 0) {
                this.remoteMultiplyLoading(entityClassStorage.getAncestors(), version, entityClassStorageMap);
            }
            return entityClassStorageMap;
        }
        catch (JsonProcessingException e) {
            this.logger.warn("{}", (Object)e.toString());
            throw new RuntimeException(e.getMessage());
        }
    }

    private EntityClassStorage getOneFromRemote(long entityClassId, int version) throws JsonProcessingException {
        Object[] keys = new String[]{this.entityStorageKeys};
        String redisValue = (String)this.syncCommands.evalsha(this.entityClassStorageScriptSha, ScriptOutputType.VALUE, keys, (Object[])new String[]{version + "", Long.toString(entityClassId)});
        Map keyValues = (Map)this.objectMapper.readValue(redisValue, Map.class);
        return EntityClassStorageConvert.redisValuesToLocalStorage(this.objectMapper, keyValues);
    }

    private void remoteMultiplyLoading(List<Long> ids, int version, Map<Long, EntityClassStorage> entityClassStorageMap) throws JsonProcessingException {
        int extraSize = ids.size();
        Object[] extraEntityIds = new String[extraSize + 1];
        extraEntityIds[0] = version + "";
        int j = 1;
        for (int i = 0; i < ids.size(); ++i) {
            extraEntityIds[j] = Long.toString(ids.get(i));
            ++j;
        }
        Object[] keys = new String[]{this.entityStorageKeys};
        String redisValue = (String)this.syncCommands.evalsha(this.entityClassStorageListScriptSha, ScriptOutputType.VALUE, keys, extraEntityIds);
        Map valuePairs = (Map)this.objectMapper.readValue(redisValue, Map.class);
        if (extraSize != valuePairs.size()) {
            throw new RuntimeException(String.format("missed some extend or children entityClassStorage, should be [%d], actual [%d] ", extraSize, valuePairs.size()));
        }
        for (Map.Entry value : valuePairs.entrySet()) {
            EntityClassStorage storage = EntityClassStorageConvert.redisValuesToLocalStorage(this.objectMapper, (Map)value.getValue());
            entityClassStorageMap.put(storage.getId(), storage);
        }
    }

    private EntityClassStorage getFromLocal(long entityClassId, int version) {
        return (EntityClassStorage)this.entityClassStorageCache.getIfPresent((Object)CacheUtils.generateEntityCacheKey(entityClassId, version));
    }

    private synchronized void addToLocal(String key, EntityClassStorage entityClassStorage) {
        EntityClassStorage e = (EntityClassStorage)this.entityClassStorageCache.getIfPresent((Object)key);
        if (null == e) {
            this.entityClassStorageCache.put((Object)key, (Object)entityClassStorage);
        }
    }

    private void invalidateFromLocal(long entityId, int version) {
        try {
            this.entityClassStorageCache.invalidate((Object)CacheUtils.generateEntityCacheKey(entityId, version));
        }
        catch (Exception e) {
            this.logger.warn("delete local failed, entityId:[{}], version:[{}], message:[{}]", new Object[]{entityId, version, e.getMessage()});
        }
    }
}

