/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.metadata.executor;

import com.xforceplus.ultraman.oqsengine.meta.common.exception.MetaSyncClientException;
import com.xforceplus.ultraman.oqsengine.meta.common.executor.IDelayTaskExecutor;
import com.xforceplus.ultraman.oqsengine.meta.common.proto.sync.EntityClassSyncRspProto;
import com.xforceplus.ultraman.oqsengine.meta.common.utils.EntityClassStorageBuilderUtils;
import com.xforceplus.ultraman.oqsengine.meta.common.utils.EntityClassStorageHelper;
import com.xforceplus.ultraman.oqsengine.meta.common.utils.ThreadUtils;
import com.xforceplus.ultraman.oqsengine.meta.common.utils.TimeWaitUtils;
import com.xforceplus.ultraman.oqsengine.meta.provider.outter.SyncExecutor;
import com.xforceplus.ultraman.oqsengine.metadata.cache.CacheExecutor;
import com.xforceplus.ultraman.oqsengine.metadata.executor.ExpireExecutor;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityClassSyncExecutor
implements SyncExecutor {
    final Logger logger = LoggerFactory.getLogger(EntityClassSyncExecutor.class);
    @Resource
    private CacheExecutor cacheExecutor;
    @Resource
    private IDelayTaskExecutor<ExpireExecutor.DelayCleanEntity> expireExecutor;
    private volatile boolean closed = false;
    private Thread thread;

    @PostConstruct
    public void start() {
        this.closed = false;
        this.thread = ThreadUtils.create(() -> {
            this.delayCleanTask();
            return true;
        });
        this.thread.start();
    }

    @PreDestroy
    public void stop() {
        this.closed = true;
        this.expireExecutor.stop();
        ThreadUtils.shutdown((Thread)this.thread, (long)3L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sync(String appId, int version, EntityClassSyncRspProto entityClassSyncRspProto) {
        if (this.cacheExecutor.prepare(appId, version)) {
            int expiredVersion = -1;
            try {
                try {
                    expiredVersion = this.version(appId);
                }
                catch (Exception e) {
                    this.logger.warn("query expiredVersion failed, [{}]", (Object)e.toString());
                    boolean bl = false;
                    this.cacheExecutor.endPrepare(appId);
                    return bl;
                }
                List entityClassStorageList = EntityClassStorageBuilderUtils.protoToStorageList((EntityClassSyncRspProto)entityClassSyncRspProto);
                try {
                    if (!this.cacheExecutor.save(appId, version, entityClassStorageList)) {
                        throw new MetaSyncClientException(String.format("save batches failed, appId : [%s], version : [%d]", appId, version), false);
                    }
                    if (expiredVersion != -1) {
                        this.expireExecutor.offer((Object)new ExpireExecutor.DelayCleanEntity(60000L, new ExpireExecutor.Expired(appId, expiredVersion)));
                    }
                    boolean bl = true;
                    return bl;
                }
                catch (Exception e) {
                    this.logger.warn("sync-error, message[{}]", (Object)e.toString());
                    boolean bl = false;
                    this.cacheExecutor.endPrepare(appId);
                    return bl;
                }
            }
            finally {
                this.cacheExecutor.endPrepare(appId);
            }
        }
        this.logger.warn("sync-prepare failed, have another sync job, current [{}]-[{}] will be canceled.", (Object)appId, (Object)version);
        return false;
    }

    public boolean dataImport(String appId, int version, String content) {
        int currentVersion = this.version(appId);
        if (version > currentVersion) {
            EntityClassSyncRspProto entityClassSyncRspProto;
            try {
                entityClassSyncRspProto = EntityClassStorageHelper.toEntityClassSyncRspProto((String)content);
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("parse data to EntityClassSyncRspProto failed, message [%s]", e.getMessage()));
            }
            if (!this.sync(appId, version, entityClassSyncRspProto)) {
                throw new RuntimeException("sync data to EntityClassSyncRspProto failed");
            }
            return true;
        }
        String message = String.format("appId [%s], current version [%d] greater than update version [%d], ignore...", appId, currentVersion, version);
        this.logger.warn(message);
        throw new RuntimeException(message);
    }

    public int version(String appId) {
        return this.cacheExecutor.version(appId);
    }

    private void delayCleanTask() {
        while (!this.closed) {
            ExpireExecutor.DelayCleanEntity task = (ExpireExecutor.DelayCleanEntity)this.expireExecutor.take();
            if (null == task || null == task.element()) {
                if (this.closed) continue;
                TimeWaitUtils.wakeupAfter((long)1L, (TimeUnit)TimeUnit.SECONDS);
                continue;
            }
            try {
                boolean isClean = this.cacheExecutor.clean(task.element().getAppId(), task.element().getVersion(), false);
                this.logger.debug("clean app : {}, version : {}\uff0c success : {}", new Object[]{task.element().getAppId(), task.element().getVersion(), isClean});
            }
            catch (Exception e) {
                this.logger.warn("clean app : {}, version : {} catch exception, message : {} , but will ignore...", new Object[]{task.element().getAppId(), task.element().getVersion(), e.getMessage()});
            }
        }
    }
}

