/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.metadata.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.xforceplus.ultraman.oqsengine.meta.common.pojo.EntityClassStorage;
import com.xforceplus.ultraman.oqsengine.meta.common.pojo.RelationStorage;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.EntityField;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class EntityClassStorageConvert {
    public static EntityClassStorage redisValuesToLocalStorage(ObjectMapper objectMapper, Map<String, String> keyValues) throws JsonProcessingException {
        String level;
        if (0 == keyValues.size()) {
            throw new RuntimeException("entityClassStorage is null, may be delete.");
        }
        EntityClassStorage entityClassStorage = new EntityClassStorage();
        String id = keyValues.remove("id");
        if (null == id || id.isEmpty()) {
            throw new RuntimeException("id is null from cache.");
        }
        entityClassStorage.setId(Long.parseLong(id));
        String code = keyValues.remove("code");
        if (null == code || code.isEmpty()) {
            throw new RuntimeException("code is null from cache.");
        }
        entityClassStorage.setCode(code);
        String name = keyValues.remove("name");
        if (null != name && !name.isEmpty()) {
            entityClassStorage.setName(name);
        }
        if (null == (level = keyValues.remove("level")) || level.isEmpty()) {
            throw new RuntimeException("level is null from cache.");
        }
        entityClassStorage.setLevel(Integer.parseInt(level));
        String version = keyValues.remove("version");
        if (null == version || version.isEmpty()) {
            throw new RuntimeException("version is null from cache.");
        }
        entityClassStorage.setVersion(Integer.parseInt(version));
        String father = keyValues.remove("father");
        if (null == father || father.isEmpty()) {
            father = "0";
        }
        entityClassStorage.setFatherId(Long.valueOf(Long.parseLong(father)));
        String ancestors = keyValues.remove("ancestors");
        if (null != ancestors && !ancestors.isEmpty()) {
            entityClassStorage.setAncestors((List)objectMapper.readValue(ancestors, objectMapper.getTypeFactory().constructParametricType(List.class, new Class[]{Long.class})));
        } else {
            entityClassStorage.setAncestors(new ArrayList());
        }
        String relations = keyValues.remove("relations");
        if (null != relations && !relations.isEmpty()) {
            List relationStorageList = (List)objectMapper.readValue(relations, objectMapper.getTypeFactory().constructParametricType(List.class, new Class[]{RelationStorage.class}));
            entityClassStorage.setRelations(relationStorageList);
        } else {
            entityClassStorage.setRelations(new ArrayList());
        }
        ArrayList<Object> fields = new ArrayList<Object>();
        for (Map.Entry<String, String> entry : keyValues.entrySet()) {
            if (!entry.getKey().startsWith("fields.")) continue;
            fields.add(objectMapper.readValue(entry.getValue(), EntityField.class));
        }
        entityClassStorage.setFields(fields);
        return entityClassStorage;
    }
}

