/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.metadata;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.xforceplus.ultraman.oqsengine.meta.common.dto.WatchElement;
import com.xforceplus.ultraman.oqsengine.meta.common.proto.sync.EntityClassSyncRspProto;
import com.xforceplus.ultraman.oqsengine.meta.common.utils.EntityClassStorageHelper;
import com.xforceplus.ultraman.oqsengine.meta.handler.IRequestHandler;
import com.xforceplus.ultraman.oqsengine.meta.provider.outter.SyncExecutor;
import com.xforceplus.ultraman.oqsengine.metadata.MetaManager;
import com.xforceplus.ultraman.oqsengine.metadata.cache.CacheExecutor;
import com.xforceplus.ultraman.oqsengine.metadata.dto.HealthCheckEntityClass;
import com.xforceplus.ultraman.oqsengine.metadata.dto.metrics.MetaMetrics;
import com.xforceplus.ultraman.oqsengine.metadata.dto.storage.EntityClassStorage;
import com.xforceplus.ultraman.oqsengine.metadata.dto.storage.ProfileStorage;
import com.xforceplus.ultraman.oqsengine.metadata.dto.storage.RelationStorage;
import com.xforceplus.ultraman.oqsengine.metadata.utils.FileReaderUtils;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.EntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.EntityField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.Relationship;
import io.micrometer.core.annotation.Timed;
import java.io.File;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageMetaManager
implements MetaManager {
    final Logger logger = LoggerFactory.getLogger(StorageMetaManager.class);
    @Resource
    private CacheExecutor cacheExecutor;
    @Resource
    private IRequestHandler requestHandler;
    @Resource(name="grpcSyncExecutor")
    private SyncExecutor syncExecutor;
    @Resource(name="taskThreadPool")
    private ExecutorService asyncDispatcher;
    private boolean isOffLineUse = false;
    private String loadPath;

    public void isOffLineUse() {
        this.isOffLineUse = true;
    }

    public void setLoadPath(String loadPath) {
        this.loadPath = loadPath;
    }

    private <T> CompletableFuture<T> async(Supplier<T> supplier) {
        return CompletableFuture.supplyAsync(supplier, this.asyncDispatcher);
    }

    @PostConstruct
    public void init() {
        if (null != this.loadPath && !this.loadPath.isEmpty()) {
            this.logger.info("start load from local path : {}", (Object)this.loadPath);
            this.loadFromLocal(this.loadPath);
            this.logger.info("success load from local path : {}", (Object)this.loadPath);
        }
    }

    @Override
    public Optional<IEntityClass> load(long id, String profile) {
        try {
            return this.innerLoad(id, profile);
        }
        catch (Exception e) {
            this.logger.warn(String.format("load entityClass [%d]-[%s] error, message [%s]", id, profile, e.getMessage()));
            return Optional.empty();
        }
    }

    @Override
    public Optional<IEntityClass> loadHistory(long id, int version) {
        return Optional.empty();
    }

    @Override
    @Timed(value="oqs.process.delay.latency", extraTags={"initiator", "meta", "action", "need"})
    public int need(String appId, String env) {
        this.cacheExecutor.appEnvSet(appId, env);
        String cacheEnv = this.cacheExecutor.appEnvGet(appId);
        if (!cacheEnv.equals(env)) {
            this.logger.warn("appId [{}], param env [{}] not equals to cache's env [{}], will use cache to register.", new Object[]{appId, env, cacheEnv});
            env = cacheEnv;
        }
        int version = this.cacheExecutor.version(appId);
        if (!this.isOffLineUse) {
            this.requestHandler.register(new WatchElement(appId, env, version, WatchElement.ElementStatus.Register));
            if (version < 0) {
                CompletableFuture<Integer> future = this.async(() -> {
                    block3: {
                        int ver;
                        while ((ver = this.cacheExecutor.version(appId)) < 0) {
                            try {
                                Thread.sleep(10L);
                            }
                            catch (InterruptedException e) {
                                break block3;
                            }
                        }
                        return ver;
                    }
                    return -1;
                });
                try {
                    version = future.get(60000L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException | ExecutionException | TimeoutException e) {
                    e.printStackTrace();
                    throw new RuntimeException(e.getMessage());
                }
                if (version == -1) {
                    throw new RuntimeException(String.format("get version of appId [%s] failed, reach max wait time", appId));
                }
            }
        } else if (version < 0) {
            throw new RuntimeException(String.format("local cache has not init this version of appId [%s].", appId));
        }
        return version;
    }

    @Override
    public void invalidateLocal() {
        this.cacheExecutor.invalidateLocal();
    }

    @Override
    public boolean dataImport(String appId, String env, int version, String content) {
        this.cacheExecutor.appEnvSet(appId, env);
        if (!this.cacheExecutor.appEnvGet(appId).equals(env)) {
            throw new RuntimeException("appId has been init with another Id, need failed...");
        }
        int currentVersion = this.cacheExecutor.version(appId);
        if (version > currentVersion) {
            EntityClassSyncRspProto entityClassSyncRspProto;
            this.logger.info("execute data import, appId {}, currentVersion {}, update version {}", new Object[]{appId, currentVersion, version});
            try {
                entityClassSyncRspProto = EntityClassStorageHelper.toEntityClassSyncRspProto((String)content);
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("parse data to EntityClassSyncRspProto failed, message [%s]", e.getMessage()));
            }
            if (!this.syncExecutor.sync(appId, version, entityClassSyncRspProto)) {
                throw new RuntimeException("sync data to EntityClassSyncRspProto failed");
            }
            return true;
        }
        String message = String.format("appId [%s], current version [%d] greater than update version [%d], ignore...", appId, currentVersion, version);
        this.logger.warn(message);
        return false;
    }

    @Override
    public Optional<MetaMetrics> showMeta(String appId) throws Exception {
        try {
            int currentVersion = this.cacheExecutor.version(appId);
            if (currentVersion == -1) {
                return Optional.empty();
            }
            String env = this.cacheExecutor.appEnvGet(appId);
            Collection<Long> ids = this.cacheExecutor.appEntityIdList(appId, currentVersion);
            Map<Long, EntityClassStorage> metas = this.cacheExecutor.multiplyRead(ids, currentVersion, false);
            return Optional.of(new MetaMetrics(currentVersion, env, appId, null != metas ? metas.values() : new ArrayList<EntityClassStorage>()));
        }
        catch (Exception e) {
            this.logger.warn("show meta error, appId {}, message : {}", (Object)appId, (Object)e.getMessage());
            throw e;
        }
    }

    private Optional<IEntityClass> innerLoad(long id, String profileCode) throws SQLException, JsonProcessingException {
        if (id == 0L) {
            return Optional.of(HealthCheckEntityClass.getInstance());
        }
        Map<Long, EntityClassStorage> entityClassStorageMaps = this.cacheExecutor.read(id);
        return Optional.of(this.toEntityClass(id, profileCode, entityClassStorageMaps));
    }

    private IEntityClass toEntityClass(long id, String profileCode, Map<Long, EntityClassStorage> entityClassStorageMaps) throws SQLException {
        ProfileStorage profileStorage;
        EntityClassStorage entityClassStorage = entityClassStorageMaps.get(id);
        if (null == entityClassStorage) {
            throw new SQLException(String.format("entity class [%d] not found.", id));
        }
        List<Relationship> relationships = this.toQqsRelation(entityClassStorage.getRelations());
        ArrayList entityFields = new ArrayList();
        if (null != entityClassStorage.getFields()) {
            entityClassStorage.getFields().forEach(e -> {
                IEntityField entityField = this.cloneEntityField((IEntityField)e);
                if (null != entityField) {
                    entityFields.add(entityField);
                }
            });
        }
        if (null != profileCode && !profileCode.equals("") && null != entityClassStorage.getProfileStorageMap() && null != (profileStorage = entityClassStorage.getProfileStorageMap().get(profileCode))) {
            if (null != profileStorage.getEntityFieldList()) {
                profileStorage.getEntityFieldList().forEach(ps -> {
                    IEntityField entityField = this.cloneEntityField((IEntityField)ps);
                    if (null != entityField) {
                        entityFields.add(entityField);
                    }
                });
            }
            if (null != profileStorage.getRelationStorageList()) {
                relationships.addAll(this.toQqsRelation(profileStorage.getRelationStorageList()));
            }
        }
        EntityClass.Builder builder = EntityClass.Builder.anEntityClass().withId(entityClassStorage.getId()).withCode(entityClassStorage.getCode()).withName(entityClassStorage.getName()).withLevel(entityClassStorage.getLevel()).withVersion(entityClassStorage.getVersion()).withProfile(profileCode).withRelations(relationships).withFields(entityFields);
        if (null != entityClassStorage.getFatherId() && entityClassStorage.getFatherId() >= 1L) {
            builder.withFather(this.toEntityClass(entityClassStorage.getFatherId(), profileCode, entityClassStorageMaps));
        }
        return builder.build();
    }

    private List<Relationship> toQqsRelation(List<RelationStorage> relationStorageList) {
        ArrayList<Relationship> relationships = new ArrayList<Relationship>();
        if (null != relationStorageList) {
            relationStorageList.forEach(r -> {
                Relationship.Builder builder = Relationship.Builder.anRelationship().withId(r.getId()).withCode(r.getCode()).withLeftEntityClassId(r.getLeftEntityClassId()).withLeftEntityClassCode(r.getLeftEntityClassCode()).withRelationType(Relationship.RelationType.getInstance((int)r.getRelationType())).withIdentity(r.isIdentity()).withStrong(r.isStrong()).withRightEntityClassId(r.getRightEntityClassId()).withRightEntityClassLoader(this::load).withEntityField(this.cloneEntityField((IEntityField)r.getEntityField())).withBelongToOwner(r.isBelongToOwner());
                relationships.add(builder.build());
            });
        }
        return relationships;
    }

    private IEntityField cloneEntityField(IEntityField entityField) {
        if (null != entityField) {
            return EntityField.Builder.anEntityField().withName(entityField.name()).withCnName(entityField.cnName()).withFieldType(entityField.type()).withDictId(entityField.dictId()).withId(entityField.id()).withDefaultValue(entityField.defaultValue()).withConfig(entityField.config().clone()).build();
        }
        return null;
    }

    private void loadFromLocal(String path) {
        if (!path.endsWith(File.separator)) {
            path = path + File.separator;
        }
        List<String> files = FileReaderUtils.getFileNamesInOneDir(path);
        for (String file : files) {
            try {
                String[] splitter = EntityClassStorageHelper.splitMetaFromFileName((String)file);
                String appId = splitter[0];
                int version = Integer.parseInt(splitter[1]);
                String fullPath = path + file;
                String v = EntityClassStorageHelper.initDataFromFilePath((String)appId, (String)splitter[2], (Integer)version, (String)fullPath);
                if (this.dataImport(splitter[0], splitter[2], version, v)) {
                    this.logger.info("init meta from local path success, path : {}, appId : {}, version : {}", new Object[]{fullPath, appId, version});
                    continue;
                }
                this.logger.warn("init meta from local path failed, less than current oqs use version, path : {}", (Object)fullPath);
            }
            catch (Exception e) {
                this.logger.warn("load from local-file failed, path : {}, message : {}", (Object)(path + file), (Object)e.getMessage());
            }
        }
    }
}

