/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.metadata.mock;

import com.google.protobuf.InvalidProtocolBufferException;
import com.xforceplus.ultraman.oqsengine.meta.common.utils.EntityClassStorageHelper;
import com.xforceplus.ultraman.oqsengine.metadata.MetaManager;
import com.xforceplus.ultraman.oqsengine.metadata.dto.metrics.MetaMetrics;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public class MockMetaManager
implements MetaManager {
    private Map<String, IEntityClass> entityClassPool = new ConcurrentHashMap<String, IEntityClass>();
    private Map<String, IEntityClass> profileEntityClassPool = new ConcurrentHashMap<String, IEntityClass>();

    public void addEntityClass(IEntityClass entityClass) {
        entityClass.family().stream().forEach(e -> this.entityClassPool.put(this.buildKey(e.id(), e.version()), (IEntityClass)e));
    }

    public void addEntityClass(IEntityClass entityClass, String profile) {
        if (profile == null) {
            this.addEntityClass(entityClass);
        } else {
            entityClass.family().stream().forEach(e -> this.entityClassPool.put(this.buildKey(e.id(), e.version(), profile), (IEntityClass)e));
        }
    }

    public Optional<IEntityClass> load(long id) {
        return Optional.ofNullable(this.entityClassPool.entrySet().stream().filter(e -> ((IEntityClass)e.getValue()).id() == id).max((e0, e1) -> {
            if (((IEntityClass)e0.getValue()).version() < ((IEntityClass)e1.getValue()).version()) {
                return -1;
            }
            if (((IEntityClass)e0.getValue()).version() > ((IEntityClass)e1.getValue()).version()) {
                return 1;
            }
            return 0;
        }).get().getValue());
    }

    @Override
    public Optional<IEntityClass> load(long id, String profile) {
        if (profile == null || profile.isEmpty()) {
            return this.load(id);
        }
        return Optional.ofNullable(this.profileEntityClassPool.entrySet().stream().filter(e -> ((IEntityClass)e.getValue()).id() == id).max((e0, e1) -> {
            if (((IEntityClass)e0.getValue()).version() < ((IEntityClass)e1.getValue()).version()) {
                return -1;
            }
            if (((IEntityClass)e0.getValue()).version() > ((IEntityClass)e1.getValue()).version()) {
                return 1;
            }
            return 0;
        }).get().getValue());
    }

    @Override
    public Optional<IEntityClass> loadHistory(long id, int version) {
        return Optional.ofNullable(this.entityClassPool.get(this.buildKey(id, version)));
    }

    @Override
    public int need(String appId, String env) {
        return 0;
    }

    @Override
    public void invalidateLocal() {
        this.entityClassPool.clear();
        this.profileEntityClassPool.clear();
    }

    @Override
    public boolean dataImport(String appId, String env, int version, String content) {
        try {
            EntityClassStorageHelper.toEntityClassSyncRspProto((String)content);
            return true;
        }
        catch (InvalidProtocolBufferException e) {
            return false;
        }
    }

    @Override
    public Optional<MetaMetrics> showMeta(String appId) {
        return Optional.empty();
    }

    private String buildKey(long id, int version) {
        return this.buildKey(id, version, null);
    }

    private String buildKey(long id, int version, String profile) {
        if (profile != null) {
            return String.format("%d-%d-%s", id, version, profile);
        }
        return String.format("%d-%d", id, version);
    }
}

