/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.metadata.utils;

import com.xforceplus.ultraman.oqsengine.meta.common.exception.MetaSyncClientException;

public class CacheUtils {
    private static final String ENTITY_STORAGE_LOCAL_CACHE_KEY = "entityStorageLocal";
    private static final int PROFILE_ENTITY_KEY_PARTS = 4;
    private static final int PROFILE_RELATION_KEY_PARTS = 3;
    private static final int PROFILE_CODE_POS = 2;

    public static String generateEntityCacheKey(long entityId, int version) {
        return "entityStorageLocal." + entityId + "." + version;
    }

    public static String generateProfileEntity(String code, long id) {
        return "profiles.fields." + code + "." + id;
    }

    public static String parseOneKeyFromProfileEntity(String key) {
        String[] parts = key.split("\\.");
        if (parts.length != 4) {
            throw new MetaSyncClientException(String.format("profileEntity key's length should be %d", 4), false);
        }
        return parts[2];
    }

    public static String generateProfileRelations(String code) {
        return "profiles.relations." + code;
    }

    public static String parseOneKeyFromProfileRelations(String key) {
        String[] parts = key.split("\\.");
        if (parts.length != 3) {
            throw new MetaSyncClientException(String.format("profileRelations key's length should be %d", 3), false);
        }
        return parts[2];
    }
}

