/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.metadata.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.xforceplus.ultraman.oqsengine.metadata.dto.storage.EntityClassStorage;
import com.xforceplus.ultraman.oqsengine.metadata.dto.storage.ProfileStorage;
import com.xforceplus.ultraman.oqsengine.metadata.dto.storage.RelationStorage;
import com.xforceplus.ultraman.oqsengine.metadata.utils.CacheUtils;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.CalculationType;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.EntityField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.calculation.AutoFill;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EntityClassStorageConvert {
    public static EntityClassStorage redisValuesToLocalStorage(ObjectMapper objectMapper, Map<String, String> keyValues) throws JsonProcessingException {
        String level;
        if (0 == keyValues.size()) {
            throw new RuntimeException("entityClassStorage is null, may be delete.");
        }
        EntityClassStorage entityClassStorage = new EntityClassStorage();
        String id = keyValues.remove("id");
        if (null == id || id.isEmpty()) {
            throw new RuntimeException("id is null from cache.");
        }
        entityClassStorage.setId(Long.parseLong(id));
        String code = keyValues.remove("code");
        if (null == code || code.isEmpty()) {
            throw new RuntimeException("code is null from cache.");
        }
        entityClassStorage.setCode(code);
        String name = keyValues.remove("name");
        if (null != name && !name.isEmpty()) {
            entityClassStorage.setName(name);
        }
        if (null == (level = keyValues.remove("level")) || level.isEmpty()) {
            throw new RuntimeException("level is null from cache.");
        }
        entityClassStorage.setLevel(Integer.parseInt(level));
        String version = keyValues.remove("version");
        if (null == version || version.isEmpty()) {
            throw new RuntimeException("version is null from cache.");
        }
        entityClassStorage.setVersion(Integer.parseInt(version));
        String father = keyValues.remove("father");
        if (null == father || father.isEmpty()) {
            father = "0";
        }
        entityClassStorage.setFatherId(Long.parseLong(father));
        String ancestors = keyValues.remove("ancestors");
        if (null != ancestors && !ancestors.isEmpty()) {
            entityClassStorage.setAncestors((List)objectMapper.readValue(ancestors, objectMapper.getTypeFactory().constructParametricType(List.class, new Class[]{Long.class})));
        } else {
            entityClassStorage.setAncestors(new ArrayList<Long>());
        }
        String relations = keyValues.remove("relations");
        if (null != relations && !relations.isEmpty()) {
            List relationStorageList = (List)objectMapper.readValue(relations, objectMapper.getTypeFactory().constructParametricType(List.class, new Class[]{RelationStorage.class}));
            entityClassStorage.setRelations(relationStorageList);
        } else {
            entityClassStorage.setRelations(new ArrayList<RelationStorage>());
        }
        ArrayList<EntityField> fields = new ArrayList<EntityField>();
        HashMap<String, ProfileStorage> profileStorageMap = new HashMap<String, ProfileStorage>();
        for (Map.Entry<String, String> entry : keyValues.entrySet()) {
            String key;
            if (entry.getKey().startsWith("fields.")) {
                fields.add(EntityClassStorageConvert.resetAutoFill((EntityField)objectMapper.readValue(entry.getValue(), EntityField.class)));
                continue;
            }
            if (entry.getKey().startsWith("profiles.fields")) {
                key = CacheUtils.parseOneKeyFromProfileEntity(entry.getKey());
                profileStorageMap.computeIfAbsent(key, ProfileStorage::new).addField(EntityClassStorageConvert.resetAutoFill((EntityField)objectMapper.readValue(entry.getValue(), EntityField.class)));
                continue;
            }
            if (!entry.getKey().startsWith("profiles.relations")) continue;
            key = CacheUtils.parseOneKeyFromProfileRelations(entry.getKey());
            String profileRelations = keyValues.get(entry.getKey());
            profileStorageMap.computeIfAbsent(key, ProfileStorage::new).setRelationStorageList((List)objectMapper.readValue(profileRelations, objectMapper.getTypeFactory().constructParametricType(List.class, new Class[]{RelationStorage.class})));
        }
        entityClassStorage.setFields(fields);
        entityClassStorage.setProfileStorageMap(profileStorageMap);
        return entityClassStorage;
    }

    private static EntityField resetAutoFill(EntityField entityField) {
        if (entityField.calculationType().equals((Object)CalculationType.AUTO_FILL)) {
            AutoFill autoFill = (AutoFill)entityField.config().getCalculation();
            if (autoFill.getDomainNoType() == null) {
                autoFill.setDomainNoType(AutoFill.DomainNoType.NORMAL);
            }
            if (autoFill.getLevel() == 0) {
                autoFill.setLevel(1);
            }
        }
        return entityField;
    }
}

