/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.metadata.dto;

public class SyncStep<T> {
    private StepDefinition stepDefinition;
    private String message;
    private T data;

    private SyncStep() {
    }

    public StepDefinition getStepDefinition() {
        return this.stepDefinition;
    }

    public void setStepDefinition(StepDefinition stepDefinition) {
        this.stepDefinition = stepDefinition;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public T getData() {
        return this.data;
    }

    public String toPersistentMessage() {
        return this.stepDefinition.name() + ":" + this.message;
    }

    public void setData(T data) {
        this.data = data;
    }

    public String messageFormat() {
        return String.format("step : %s, message : %s", this.stepDefinition.name(), this.message);
    }

    public static SyncStep ok() {
        SyncStep step = new SyncStep();
        step.stepDefinition = StepDefinition.SUCCESS;
        step.message = "step ok";
        return step;
    }

    public static <T> SyncStep<T> ok(T data) {
        SyncStep step = SyncStep.ok();
        step.data = data;
        step.stepDefinition = StepDefinition.SUCCESS;
        return step;
    }

    public static SyncStep failed(StepDefinition stepDefinition, String message) {
        SyncStep step = new SyncStep();
        step.stepDefinition = stepDefinition;
        step.message = message;
        return step;
    }

    public static enum StepDefinition {
        UNKNOWN,
        SYNC_CLIENT_FAILED,
        DUPLICATE_PREPARE_FAILED,
        QUERY_VERSION_FAILED,
        QUERY_EX_APP_META_FAILED,
        PARSER_PROTO_BUF_FAILED,
        SAVE_ENTITY_CLASS_STORAGE_FAILED,
        BUILD_EVENT_FAILED,
        SUCCESS;

    }
}

