/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.metadata.executor;

import com.xforceplus.ultraman.oqsengine.event.ActualEvent;
import com.xforceplus.ultraman.oqsengine.event.Event;
import com.xforceplus.ultraman.oqsengine.event.EventBus;
import com.xforceplus.ultraman.oqsengine.event.EventType;
import com.xforceplus.ultraman.oqsengine.event.payload.meta.MetaChangePayLoad;
import com.xforceplus.ultraman.oqsengine.meta.common.exception.MetaSyncClientException;
import com.xforceplus.ultraman.oqsengine.meta.common.executor.IDelayTaskExecutor;
import com.xforceplus.ultraman.oqsengine.meta.common.proto.sync.EntityClassSyncRspProto;
import com.xforceplus.ultraman.oqsengine.meta.common.utils.ThreadUtils;
import com.xforceplus.ultraman.oqsengine.meta.common.utils.TimeWaitUtils;
import com.xforceplus.ultraman.oqsengine.meta.provider.outter.SyncExecutor;
import com.xforceplus.ultraman.oqsengine.metadata.cache.CacheExecutor;
import com.xforceplus.ultraman.oqsengine.metadata.dto.SyncStep;
import com.xforceplus.ultraman.oqsengine.metadata.dto.storage.EntityClassStorage;
import com.xforceplus.ultraman.oqsengine.metadata.executor.ExpireExecutor;
import com.xforceplus.ultraman.oqsengine.metadata.utils.storage.EntityClassStorageBuilderUtils;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityClassSyncExecutor
implements SyncExecutor {
    final Logger logger = LoggerFactory.getLogger(EntityClassSyncExecutor.class);
    @Resource
    private CacheExecutor cacheExecutor;
    @Resource
    private IDelayTaskExecutor<ExpireExecutor.DelayCleanEntity> expireExecutor;
    @Resource
    private EventBus eventBus;
    private volatile boolean closed = false;
    private Thread thread;

    @PostConstruct
    public void start() {
        this.closed = false;
        this.thread = ThreadUtils.create(() -> {
            this.delayCleanTask();
            return true;
        });
        this.thread.start();
    }

    @PreDestroy
    public void stop() {
        this.closed = true;
        this.expireExecutor.stop();
        ThreadUtils.shutdown((Thread)this.thread, (long)3L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sync(String appId, int version, EntityClassSyncRspProto entityClassSyncRspProto) {
        int expiredVersion = -1;
        MetaChangePayLoad metaChangePayLoad = null;
        SyncStep<Object> step = SyncStep.failed(SyncStep.StepDefinition.UNKNOWN, "");
        boolean openPrepare = false;
        try {
            step = this.prepared(appId, version);
            if (!step.getStepDefinition().equals((Object)SyncStep.StepDefinition.SUCCESS)) {
                throw new MetaSyncClientException(step.messageFormat(), false);
            }
            openPrepare = true;
            step = this.querySyncVersion(appId);
            if (!step.getStepDefinition().equals((Object)SyncStep.StepDefinition.SUCCESS)) {
                throw new MetaSyncClientException(step.messageFormat(), false);
            }
            expiredVersion = (Integer)step.getData();
            step = this.parserProto(entityClassSyncRspProto);
            if (!step.getStepDefinition().equals((Object)SyncStep.StepDefinition.SUCCESS)) {
                throw new MetaSyncClientException(step.messageFormat(), false);
            }
            if (!(step = this.save(appId, version, (List)step.getData())).getStepDefinition().equals((Object)SyncStep.StepDefinition.SUCCESS)) {
                throw new MetaSyncClientException(step.messageFormat(), false);
            }
            metaChangePayLoad = (MetaChangePayLoad)step.getData();
        }
        catch (Throwable throwable) {
            if (step.getStepDefinition().equals((Object)SyncStep.StepDefinition.SUCCESS)) {
                if (expiredVersion != -1) {
                    this.expireExecutor.offer((Object)new ExpireExecutor.DelayCleanEntity(60000L, new ExpireExecutor.Expired(appId, expiredVersion)));
                }
                this.eventPublish(metaChangePayLoad);
            }
            if (openPrepare) {
                this.cacheExecutor.endPrepare(appId);
            }
            throw throwable;
        }
        if (step.getStepDefinition().equals((Object)SyncStep.StepDefinition.SUCCESS)) {
            if (expiredVersion != -1) {
                this.expireExecutor.offer((Object)new ExpireExecutor.DelayCleanEntity(60000L, new ExpireExecutor.Expired(appId, expiredVersion)));
            }
            this.eventPublish(metaChangePayLoad);
        }
        if (openPrepare) {
            this.cacheExecutor.endPrepare(appId);
        }
    }

    private SyncStep<Boolean> prepared(String appId, int version) {
        return this.cacheExecutor.prepare(appId, version) ? SyncStep.ok(true) : SyncStep.failed(SyncStep.StepDefinition.DUPLICATE_PREPARE_FAILED, String.format("sync-prepare failed, have another sync job, current [%s]-[%d] will be canceled.", appId, version));
    }

    private SyncStep<Integer> querySyncVersion(String appId) {
        try {
            return SyncStep.ok(this.version(appId));
        }
        catch (Exception e) {
            String message = String.format("query expiredVersion failed, appId : %s, %s", appId, e.getMessage());
            return SyncStep.failed(SyncStep.StepDefinition.QUERY_VERSION_FAILED, message);
        }
    }

    private SyncStep<List<EntityClassStorage>> parserProto(EntityClassSyncRspProto entityClassSyncRspProto) {
        try {
            return SyncStep.ok(EntityClassStorageBuilderUtils.protoToStorageList(entityClassSyncRspProto));
        }
        catch (Exception e) {
            return SyncStep.failed(SyncStep.StepDefinition.PARSER_PROTO_BUF_FAILED, String.format("parser meta proto failed, [%s]", e.getMessage()));
        }
    }

    private SyncStep<MetaChangePayLoad> save(String appId, int version, List<EntityClassStorage> entityClassStorages) {
        try {
            MetaChangePayLoad metaChangePayLoad = this.cacheExecutor.save(appId, version, entityClassStorages);
            return SyncStep.ok(metaChangePayLoad);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return SyncStep.failed(SyncStep.StepDefinition.SAVE_ENTITY_CLASS_STORAGE_FAILED, e.getMessage());
        }
    }

    public int version(String appId) {
        return this.cacheExecutor.version(appId);
    }

    private void delayCleanTask() {
        while (!this.closed) {
            ExpireExecutor.DelayCleanEntity task = (ExpireExecutor.DelayCleanEntity)this.expireExecutor.take();
            if (null == task || null == task.element()) {
                if (this.closed) continue;
                TimeWaitUtils.wakeupAfter((long)1L, (TimeUnit)TimeUnit.SECONDS);
                continue;
            }
            try {
                boolean isClean = this.cacheExecutor.clean(task.element().getAppId(), task.element().getVersion(), false);
                this.logger.debug("clean app : {}, version : {}\uff0c success : {}", new Object[]{task.element().getAppId(), task.element().getVersion(), isClean});
            }
            catch (Exception e) {
                this.logger.warn("clean app : {}, version : {} catch exception, message : {} , but will ignore...", new Object[]{task.element().getAppId(), task.element().getVersion(), e.getMessage()});
            }
        }
    }

    private void eventPublish(MetaChangePayLoad metaChangePayLoad) {
        if (null != metaChangePayLoad) {
            this.logger.info("ready for publish event on appId:[{}]", (Object)metaChangePayLoad.getAppId());
            if (!metaChangePayLoad.getEntityChanges().isEmpty()) {
                this.eventBus.notify((Event)new ActualEvent(EventType.META_DATA_CHANGE, (Serializable)metaChangePayLoad));
                this.logger.info("publish event ok.");
            } else {
                this.logger.info("empty event change, nothing to publish.");
            }
        }
    }
}

