/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.metadata.mock;

import com.xforceplus.ultraman.oqsengine.common.mock.BeanInitialization;
import com.xforceplus.ultraman.oqsengine.common.mock.CommonInitialization;
import com.xforceplus.ultraman.oqsengine.common.mock.InitializationHelper;
import com.xforceplus.ultraman.oqsengine.common.mock.ReflectionUtils;
import com.xforceplus.ultraman.oqsengine.event.Event;
import com.xforceplus.ultraman.oqsengine.event.EventBus;
import com.xforceplus.ultraman.oqsengine.event.EventType;
import com.xforceplus.ultraman.oqsengine.metadata.MetaManager;
import com.xforceplus.ultraman.oqsengine.metadata.cache.DefaultCacheExecutor;
import com.xforceplus.ultraman.oqsengine.metadata.executor.EntityClassSyncExecutor;
import com.xforceplus.ultraman.oqsengine.metadata.executor.ExpireExecutor;
import com.xforceplus.ultraman.oqsengine.metadata.mock.MockMetaManager;
import java.util.Collection;
import java.util.function.Consumer;

public class MetaInitialization
implements BeanInitialization {
    private static volatile MetaInitialization instance = null;
    public DefaultCacheExecutor cacheExecutor;
    public EntityClassSyncExecutor entityClassSyncExecutor;
    public MetaManager metaManager;

    private MetaInitialization() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MetaInitialization getInstance() throws IllegalAccessException {
        if (null != instance) return instance;
        Class<MetaInitialization> clazz = MetaInitialization.class;
        synchronized (MetaInitialization.class) {
            if (null != instance) return instance;
            instance = new MetaInitialization();
            instance.init();
            InitializationHelper.add((BeanInitialization)instance);
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void init() throws IllegalAccessException {
        this.cacheExecutor = new DefaultCacheExecutor();
        Collection fields = ReflectionUtils.printAllMembers((Object)this.cacheExecutor);
        ReflectionUtils.reflectionFieldValue((Collection)fields, (String)"redisClient", (Object)this.cacheExecutor, (Object)CommonInitialization.getInstance().getRedisClient());
        this.cacheExecutor.init();
        this.entityClassSyncExecutor = new EntityClassSyncExecutor();
        Collection cacheFields = ReflectionUtils.printAllMembers((Object)this.entityClassSyncExecutor);
        ReflectionUtils.reflectionFieldValue((Collection)cacheFields, (String)"cacheExecutor", (Object)this.entityClassSyncExecutor, (Object)this.cacheExecutor);
        ReflectionUtils.reflectionFieldValue((Collection)cacheFields, (String)"expireExecutor", (Object)this.entityClassSyncExecutor, (Object)new ExpireExecutor());
        ReflectionUtils.reflectionFieldValue((Collection)cacheFields, (String)"eventBus", (Object)this.entityClassSyncExecutor, (Object)new EventBus(){

            public void watch(EventType type, Consumer<Event> listener) {
                if (!type.equals((Object)EventType.META_DATA_CHANGE)) {
                    throw new IllegalArgumentException(String.format("type %s not equals to %s", type, EventType.META_DATA_CHANGE));
                }
            }

            public void notify(Event event) {
                if (!event.type().equals((Object)EventType.META_DATA_CHANGE)) {
                    throw new IllegalArgumentException(String.format("type %s not equals to %s", event.type(), EventType.META_DATA_CHANGE));
                }
            }
        });
        this.entityClassSyncExecutor.start();
        this.metaManager = new MockMetaManager();
    }

    public void clear() throws Exception {
        if (null != this.metaManager) {
            this.metaManager.invalidateLocal();
        }
    }

    public void destroy() throws Exception {
        this.cacheExecutor.destroy();
        this.entityClassSyncExecutor.stop();
        this.metaManager = null;
        instance = null;
    }

    public DefaultCacheExecutor getCacheExecutor() {
        return this.cacheExecutor;
    }

    public EntityClassSyncExecutor getEntityClassSyncExecutor() {
        return this.entityClassSyncExecutor;
    }

    public MetaManager getMetaManager() {
        return this.metaManager;
    }

    public void setMetaManager(MetaManager metaManager) {
        this.metaManager = metaManager;
    }
}

